/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.exporter;

import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.SemanticAttributes;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.awaitility.Awaitility;
import org.testng.Assert;

@ApplicationScoped
public class InMemorySpanExporter
implements SpanExporter {
    private boolean isStopped = false;
    private final List<SpanData> finishedSpanItems = new CopyOnWriteArrayList<SpanData>();

    public List<SpanData> getFinishedSpanItems(int spanCount) {
        this.assertSpanCount(spanCount);
        return this.finishedSpanItems.stream().sorted(Comparator.comparingLong(SpanData::getStartEpochNanos).reversed()).collect(Collectors.toList());
    }

    public void assertSpanCount(int spanCount) {
        Awaitility.await().pollDelay(3L, TimeUnit.SECONDS).atMost(10L, TimeUnit.SECONDS).untilAsserted(() -> Assert.assertEquals((int)this.finishedSpanItems.size(), (int)spanCount));
    }

    public void reset() {
        this.finishedSpanItems.clear();
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isStopped) {
            return CompletableResultCode.ofFailure();
        }
        spans.stream().filter(Predicate.not(InMemorySpanExporter::isArquillianSpan)).forEach(this.finishedSpanItems::add);
        return CompletableResultCode.ofSuccess();
    }

    private static boolean isArquillianSpan(SpanData span) {
        String path = (String)span.getAttributes().get(SemanticAttributes.HTTP_ROUTE);
        if (path == null) {
            path = (String)span.getAttributes().get(SemanticAttributes.URL_QUERY);
        }
        return path != null && (path.contains("/ArquillianServletRunner") || path.contains("/ArquillianRESTRunnerEE9") || path.contains("/ArquillianServletRunnerEE9"));
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.finishedSpanItems.clear();
        this.isStopped = true;
        return CompletableResultCode.ofSuccess();
    }

    public SpanData getFirst(SpanKind spanKind) {
        return this.finishedSpanItems.stream().filter(span -> span.getKind() == spanKind).findFirst().orElseThrow(() -> new IllegalStateException("No span found with kind " + spanKind));
    }

    public List<SpanData> getSpansWithKind(SpanKind spanKind) {
        return this.finishedSpanItems.stream().filter(span -> span.getKind() == spanKind).collect(Collectors.toList());
    }
}

