/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.BaseClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ChildClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithURLRequestFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class InheritanceTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(InheritanceTest.class.getSimpleName() + ".war"))).addPackage(ReturnWithURLRequestFilter.class.getPackage())).addClasses(new Class[]{BaseClient.class, ChildClient.class});
    }

    @Test
    public void canInvokeMethodOnBaseInterface() throws Exception {
        ReturnWithURLRequestFilter filter = new ReturnWithURLRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter);
        BaseClient client = (BaseClient)builder.baseUri(new URI("http://localhost/stub")).build(ChildClient.class);
        Response response = client.executeBaseGet();
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response status code");
        String responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Response entity is null");
        Assert.assertTrue((responseStr.contains("GET ") && responseStr.contains("/base") ? 1 : 0) != 0, (String)("Did not invoke expected method/URI. Expected GET .../base ; got " + responseStr));
    }

    @Test
    public void canInvokeMethodOnChildInterface() throws Exception {
        ReturnWithURLRequestFilter filter = new ReturnWithURLRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter);
        ChildClient client = (ChildClient)builder.baseUri(new URI("http://localhost/stub")).build(ChildClient.class);
        Response response = client.executeChildGet();
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response status code");
        String responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Response entity is null");
        Assert.assertTrue((responseStr.contains("GET ") && responseStr.contains("/child") ? 1 : 0) != 0, (String)("Did not invoke expected method/URI. Expected GET .../child ; got " + responseStr));
    }

    @Test
    public void canInvokeOverriddenMethodOnChildInterface() throws Exception {
        ReturnWithURLRequestFilter filter = new ReturnWithURLRequestFilter();
        RestClientBuilder builder = (RestClientBuilder)RestClientBuilder.newBuilder().register((Object)filter);
        BaseClient client = (BaseClient)builder.baseUri(new URI("http://localhost/stub")).build(ChildClient.class);
        Response response = client.executeBasePost();
        Assert.assertEquals((int)response.getStatus(), (int)200, (String)"Unexpected response status code");
        String responseStr = (String)response.readEntity(String.class);
        Assert.assertNotNull((Object)responseStr, (String)"Response entity is null");
        Assert.assertTrue((responseStr.contains("POST ") && responseStr.contains("/childOverride") ? 1 : 0) != 0, (String)("Did not invoke expected method/URI. Expected POST .../childOverride ; got " + responseStr));
    }
}

