/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.ext;

import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigValue;
import org.eclipse.microprofile.config.spi.ConfigBuilder;
import org.eclipse.microprofile.config.spi.ConfigProviderResolver;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.Converter;

public class MockConfigProviderResolver
extends ConfigProviderResolver {
    public Config getConfig() {
        return new Config(){

            public <T> T getValue(String propertyName, Class<T> propertyType) {
                Map props = this.getConfigSources().iterator().next().getProperties();
                if (!props.containsKey(propertyName)) {
                    throw new NoSuchElementException("Unknown propertyName: " + propertyName);
                }
                String value = (String)props.get(propertyName);
                if (String.class.equals(propertyType)) {
                    return (T)value;
                }
                return null;
            }

            public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
                try {
                    return Optional.ofNullable(this.getValue(propertyName, propertyType));
                }
                catch (NoSuchElementException ex) {
                    return Optional.empty();
                }
            }

            public Iterable<String> getPropertyNames() {
                return this.getSystemProps().keySet();
            }

            public Iterable<ConfigSource> getConfigSources() {
                return Collections.singleton(new ConfigSource(){

                    public Map<String, String> getProperties() {
                        return this.getSystemProps();
                    }

                    public String getValue(String propertyName) {
                        return this.getSystemProps().get(propertyName);
                    }

                    public String getName() {
                        return "MockConfigSource";
                    }

                    public Set<String> getPropertyNames() {
                        return this.getSystemProps().keySet();
                    }
                });
            }

            private Map<String, String> getSystemProps() {
                Properties sysProps = System.getProperties();
                return sysProps;
            }

            public ConfigValue getConfigValue(final String propertyName) {
                return new ConfigValue(){

                    public String getName() {
                        return propertyName;
                    }

                    public String getValue() {
                        return this.getSystemProps().get(propertyName);
                    }

                    public String getRawValue() {
                        return this.getSystemProps().get(propertyName);
                    }

                    public String getSourceName() {
                        return this.getConfigSources().iterator().next().getName();
                    }

                    public int getSourceOrdinal() {
                        return this.getConfigSources().iterator().next().getOrdinal();
                    }
                };
            }

            public <T> Optional<Converter<T>> getConverter(Class<T> forType) {
                return Optional.empty();
            }

            public <T> T unwrap(Class<T> type) {
                throw new IllegalArgumentException();
            }
        };
    }

    public Config getConfig(ClassLoader loader) {
        return this.getConfig();
    }

    public ConfigBuilder getBuilder() {
        return null;
    }

    public void registerConfig(Config config, ClassLoader classLoader) {
    }

    public void releaseConfig(Config config) {
    }
}

