/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.rest.client.tck;

import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientBuilderHeaderClient;
import org.eclipse.microprofile.rest.client.tck.interfaces.ClientBuilderHeaderMethodClient;
import org.eclipse.microprofile.rest.client.tck.providers.ReturnWithAllDuplicateClientHeadersFilter;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ClientBuilderHeaderTest
extends Arquillian {
    @Deployment
    public static Archive<?> createDeployment() {
        return ((WebArchive)ShrinkWrap.create(WebArchive.class, (String)(ClientBuilderHeaderTest.class.getSimpleName() + ".war"))).addClasses(new Class[]{ClientBuilderHeaderClient.class, ClientBuilderHeaderMethodClient.class, ReturnWithAllDuplicateClientHeadersFilter.class});
    }

    @Test
    public void testHeaderBuilderMethod() {
        RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri("http://localhost:8080/");
        builder.register(ReturnWithAllDuplicateClientHeadersFilter.class);
        builder.header("InterfaceAndBuilderHeader", (Object)"builder");
        ClientBuilderHeaderMethodClient client = (ClientBuilderHeaderMethodClient)builder.build(ClientBuilderHeaderMethodClient.class);
        ClientBuilderHeaderTest.checkHeaders(client.getAllHeaders("headerparam"), "method");
    }

    @Test
    public void testHeaderBuilderInterface() {
        RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri("http://localhost:8080/");
        builder.register(ReturnWithAllDuplicateClientHeadersFilter.class);
        builder.header("InterfaceAndBuilderHeader", (Object)"builder");
        ClientBuilderHeaderClient client = (ClientBuilderHeaderClient)builder.build(ClientBuilderHeaderClient.class);
        ClientBuilderHeaderTest.checkHeaders(client.getAllHeaders("headerparam"), "interface");
    }

    @Test
    public void testHeaderBuilderMethodNullValue() {
        RestClientBuilder builder = RestClientBuilder.newBuilder().baseUri("http://localhost:8080/");
        try {
            builder.header("BuilderHeader", null);
        }
        catch (NullPointerException npe) {
            return;
        }
        Assert.fail((String)"header(\"builderHeader\", null) should have thrown a NullPointerException");
    }

    private static void checkHeaders(JsonObject headers, String clientHeaderParamName) {
        List<String> clientRequestHeaders = ClientBuilderHeaderTest.headerValues(headers, "InterfaceAndBuilderHeader");
        Assert.assertTrue((boolean)clientRequestHeaders.contains("builder"), (String)("Header InterfaceAndBuilderHeader did not container \"builder\": " + clientRequestHeaders));
        Assert.assertTrue((boolean)clientRequestHeaders.contains(clientHeaderParamName), (String)("Header InterfaceAndBuilderHeader did not container \"" + clientHeaderParamName + "\": " + clientRequestHeaders));
        List<String> headerParamHeaders = ClientBuilderHeaderTest.headerValues(headers, "HeaderParam");
        Assert.assertTrue((boolean)headerParamHeaders.contains("headerparam"), (String)("Header HeaderParam did not container \"headerparam\": " + headerParamHeaders));
    }

    private static List<String> headerValues(JsonObject headers, String headerName) {
        JsonArray headerValues = headers.getJsonArray(headerName);
        Assert.assertNotNull((Object)headerValues, (String)String.format("Expected header '%s' to be present in %s", headerName, headers));
        return headerValues.stream().map(v -> v.getValueType() == JsonValue.ValueType.STRING ? ((JsonString)v).getString() : v.toString()).collect(Collectors.toList());
    }
}

