/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.signatures.processors;

import jakarta.enterprise.context.ApplicationScoped;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class PublisherBean {
    private Map<String, List<String>> collector = new ConcurrentHashMap<String, List<String>>();
    private static final List<String> EXPECTED = Arrays.asList("1", "1", "2", "2", "3", "3", "4", "4", "5", "5", "6", "6", "7", "7", "8", "8", "9", "9", "10", "10");

    @Outgoing(value="publisher-for-processor-publisher-message")
    public PublisherBuilder<Integer> streamForProcessorOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-publisher-payload")
    public PublisherBuilder<Integer> streamForProcessorOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-publisher-builder-message")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfMessages() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Outgoing(value="publisher-for-processor-publisher-builder-payload")
    public PublisherBuilder<Integer> streamForProcessorBuilderOfPayloads() {
        return ReactiveStreams.of((Object[])new Integer[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9});
    }

    @Incoming(value="processor-publisher-message")
    public void getMessgesFromProcessorOfMessages(String value) {
        this.add("processor-message", value);
    }

    @Incoming(value="processor-publisher-payload")
    public void getMessgesFromProcessorOfPayloads(String value) {
        this.add("processor-payload", value);
    }

    @Incoming(value="processor-publisher-builder-message")
    public void getMessgesFromProcessorBuilderOfMessages(String value) {
        this.add("processor-builder-message", value);
    }

    @Incoming(value="processor-publisher-builder-payload")
    public void getMessgesFromProcessorBuilderOfPayloads(String value) {
        this.add("processor-builder-payload", value);
    }

    @Incoming(value="publisher-for-processor-publisher-message")
    @Outgoing(value="processor-publisher-message")
    public Publisher<Message<String>> processorOfMessages(Message<Integer> message) {
        return ReactiveStreams.of(message).map(Message::getPayload).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of).buildRs();
    }

    @Incoming(value="publisher-for-processor-publisher-payload")
    @Outgoing(value="processor-publisher-payload")
    public Publisher<String> processorOfPayloads(int value) {
        return ReactiveStreams.of((Object)value).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).buildRs();
    }

    @Incoming(value="publisher-for-processor-publisher-builder-message")
    @Outgoing(value="processor-publisher-builder-message")
    public PublisherBuilder<Message<String>> processorBuilderOfMessages(Message<Integer> message) {
        return ReactiveStreams.of(message).map(Message::getPayload).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i)).map(Message::of);
    }

    @Incoming(value="publisher-for-processor-publisher-builder-payload")
    @Outgoing(value="processor-publisher-builder-payload")
    public PublisherBuilder<String> processorBuilderOfPayloads(int value) {
        return ReactiveStreams.of((Object)value).map(i -> i + 1).flatMap(i -> ReactiveStreams.of((Object[])new Integer[]{i, i})).map(i -> Integer.toString(i));
    }

    private void add(String key, String value) {
        this.collector.computeIfAbsent(key, x -> new CopyOnWriteArrayList()).add(value);
    }

    void verify() {
        Awaitility.await().until(() -> this.collector.size() == 4);
        ((MapAssert)Assertions.assertThat(this.collector).hasSize(4)).allSatisfy((k, v) -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)v).containsExactlyElementsOf(EXPECTED);
        });
    }
}

