/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.reactive.messaging.tck.channel;

import jakarta.inject.Inject;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.eclipse.microprofile.reactive.messaging.tck.TckBase;
import org.eclipse.microprofile.reactive.messaging.tck.channel.MyBeanEmittingPayloadsWithAck;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;

public class EmitterInjectionPayloadsWithAckTest
extends TckBase {
    @Inject
    private MyBeanEmittingPayloadsWithAck myBeanEmittingPayloadsWithAck;

    @Deployment
    public static Archive<JavaArchive> deployment() {
        return EmitterInjectionPayloadsWithAckTest.getBaseArchive().addClasses(new Class[]{MyBeanEmittingPayloadsWithAck.class});
    }

    @Test
    public void testWithPayloadsAndAck() {
        this.myBeanEmittingPayloadsWithAck.run();
        List<CompletionStage<Void>> cs = this.myBeanEmittingPayloadsWithAck.getCompletionStage();
        Assertions.assertThat(this.myBeanEmittingPayloadsWithAck.emitter()).isNotNull();
        Assertions.assertThat((boolean)cs.get(0).toCompletableFuture().isDone()).isTrue();
        Assertions.assertThat((boolean)cs.get(1).toCompletableFuture().isDone()).isTrue();
        Assertions.assertThat((boolean)cs.get(2).toCompletableFuture().isDone()).isFalse();
        Awaitility.await().until(() -> this.myBeanEmittingPayloadsWithAck.list().size() == 3);
        Assertions.assertThat(this.myBeanEmittingPayloadsWithAck.list()).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((boolean)this.myBeanEmittingPayloadsWithAck.emitter().isCancelled()).isTrue();
        Assertions.assertThat((boolean)this.myBeanEmittingPayloadsWithAck.emitter().hasRequests()).isFalse();
    }
}

