/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics;

import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.FallbackMetricBean;
import org.eclipse.microprofile.fault.tolerance.tck.metrics.common.FallbackMetricHandler;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.InMemoryMetricReader;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.PullExporterAutoConfigurationCustomizerProvider;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricDefinition;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricGetter;
import org.eclipse.microprofile.fault.tolerance.tck.util.Exceptions;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FallbackTelemetryTest
extends Arquillian {
    @Inject
    private FallbackMetricBean fallbackBean;

    @Deployment
    public static WebArchive deploy() {
        WebArchive war = (WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftMetricFallback.war")).addClasses(new Class[]{FallbackMetricBean.class, FallbackMetricHandler.class})).addPackage(Packages.UTILS)).addPackage(Packages.TELEMETRY_METRIC_UTILS)).addAsWebInfResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).addAsResource((Asset)new StringAsset("otel.sdk.disabled=false\notel.traces.exporter=none"), "META-INF/microprofile-config.properties")).addAsServiceProvider(AutoConfigurationCustomizerProvider.class, new Class[]{PullExporterAutoConfigurationCustomizerProvider.class});
        return war;
    }

    @Test(groups={"main"})
    public void fallbackMetricMethodTest() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(FallbackMetricBean.class, "doWork");
        m.baselineMetrics();
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        this.fallbackBean.doWork(FallbackMetricBean.Action.PASS);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.doWork(FallbackMetricBean.Action.FAIL);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.FAIL);
        Exceptions.expectTestException(() -> this.fallbackBean.doWork(FallbackMetricBean.Action.FAIL));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        Assert.expectThrows(FallbackMetricBean.NonFallbackException.class, () -> this.fallbackBean.doWork(FallbackMetricBean.Action.NON_FALLBACK_EXCEPTION));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(groups={"main"})
    public void fallbackMetricHandlerTest() {
        TelemetryMetricGetter m = new TelemetryMetricGetter(FallbackMetricBean.class, "doWorkWithHandler");
        m.baselineMetrics();
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.PASS);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.FAIL);
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.FAIL);
        Exceptions.expectTestException(() -> this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.FAIL));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)0L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        this.fallbackBean.setFallbackAction(FallbackMetricBean.Action.PASS);
        Assert.expectThrows(FallbackMetricBean.NonFallbackException.class, () -> this.fallbackBean.doWorkWithHandler(FallbackMetricBean.Action.NON_FALLBACK_EXCEPTION));
        MatcherAssert.assertThat((String)"successful without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"successful with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.VALUE_RETURNED, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed without fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.NOT_APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
        MatcherAssert.assertThat((String)"failed with fallback", (Object)m.getInvocations(TelemetryMetricDefinition.InvocationResult.EXCEPTION_THROWN, TelemetryMetricDefinition.InvocationFallback.APPLIED).delta(), (Matcher)Matchers.is((Object)1L));
    }

    @Test(dependsOnGroups={"main"})
    public void testMetricUnits() throws InterruptedException, ExecutionException {
        InMemoryMetricReader reader = InMemoryMetricReader.current();
        for (TelemetryMetricDefinition metric : TelemetryMetricDefinition.values()) {
            if (!metric.getName().equals("ft.invocations.total")) continue;
            String unit = reader.getUnit(metric.getName());
            if (metric.getUnit() == null) {
                Assert.assertTrue((boolean)unit.isEmpty(), (String)("Unexpected metadata for metric " + metric.getName()));
                continue;
            }
            Assert.assertFalse((boolean)unit.isEmpty(), (String)("Missing metadata for metric " + metric.getName()));
            Assert.assertEquals((String)unit, (String)metric.getUnit(), (String)("Incorrect unit for metric " + metric.getName()));
        }
    }
}

