/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.disableEnv;

import jakarta.inject.Inject;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.disableEnv.DisableAnnotationClient;
import org.eclipse.microprofile.fault.tolerance.tck.disableEnv.DisableConfigAsset;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncCaller;
import org.eclipse.microprofile.fault.tolerance.tck.util.AsyncTaskManager;
import org.eclipse.microprofile.fault.tolerance.tck.util.Packages;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.Bulkhead;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.testng.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.testng.Assert;
import org.testng.annotations.Test;

public class DisableAnnotationOnClassTest
extends Arquillian {
    @Inject
    private DisableAnnotationClient disableClient;

    @Deployment
    public static WebArchive deploy() {
        DisableConfigAsset config = new DisableConfigAsset().disable(DisableAnnotationClient.class, Retry.class).disable(DisableAnnotationClient.class, CircuitBreaker.class).disable(DisableAnnotationClient.class, Timeout.class).disable(DisableAnnotationClient.class, Asynchronous.class).disable(DisableAnnotationClient.class, Fallback.class).disable(DisableAnnotationClient.class, Bulkhead.class).enable(AsyncCaller.class, Asynchronous.class);
        JavaArchive testJar = (JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"ftDisableClass.jar")).addClasses(new Class[]{DisableAnnotationClient.class})).addPackage(Packages.UTILS)).addAsManifestResource((Asset)config, "microprofile-config.properties")).addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml")).as(JavaArchive.class);
        WebArchive war = (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"ftDisableClass.war")).addAsLibrary((Archive)testJar);
        return war;
    }

    @Test
    public void testRetryDisabled() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failAndRetryOnce());
        Assert.assertEquals((int)this.disableClient.getFailAndRetryOnceCounter(), (int)1, (String)"Retry disabled - should be 1 exection");
    }

    @Test
    public void testFallbackDisabled() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failRetryOnceThenFallback());
        Assert.assertEquals((int)this.disableClient.getFailRetryOnceThenFallbackCounter(), (int)1, (String)"Retry disabled - should be 1 execution");
    }

    @Test
    public void testCircuitClosedThenOpen() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failWithCircuitBreaker());
        Assert.assertThrows(TestException.class, () -> this.disableClient.failWithCircuitBreaker());
    }

    @Test
    public void testTimeout() {
        Assert.assertThrows(TestException.class, () -> this.disableClient.failWithTimeout());
    }

    @Test
    public void testAsync() throws InterruptedException, ExecutionException {
        Future<String> result = this.disableClient.asyncWaitThenReturn();
        try {
            Assert.assertTrue((boolean)result.isDone(), (String)"Returned future.isDone() expected true because Async disabled");
        }
        finally {
            result.get();
        }
    }

    @Test
    public void testBulkhead() {
        try (AsyncTaskManager taskManager = new AsyncTaskManager();){
            AsyncTaskManager.BarrierTask<Void> task1 = taskManager.runBarrierTask(this.disableClient::waitWithBulkhead);
            AsyncTaskManager.BarrierTask<Void> task2 = taskManager.runBarrierTask(this.disableClient::waitWithBulkhead);
            task1.assertAwaits();
            task2.assertAwaits();
            AsyncTaskManager.BarrierTask<Void> task3 = taskManager.runBarrierTask(this.disableClient::waitWithBulkhead);
            task3.openBarrier();
            task3.assertSuccess();
        }
    }
}

