/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.circuitbreaker.clientserver;

import jakarta.enterprise.context.RequestScoped;
import java.io.Serializable;
import java.sql.Connection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.eclipse.microprofile.fault.tolerance.tck.util.TCKConfig;
import org.eclipse.microprofile.fault.tolerance.tck.util.TestException;
import org.eclipse.microprofile.faulttolerance.Asynchronous;
import org.eclipse.microprofile.faulttolerance.CircuitBreaker;
import org.eclipse.microprofile.faulttolerance.Retry;
import org.eclipse.microprofile.faulttolerance.Timeout;
import org.eclipse.microprofile.faulttolerance.exceptions.CircuitBreakerOpenException;
import org.eclipse.microprofile.faulttolerance.exceptions.TimeoutException;
import org.testng.Assert;

@RequestScoped
public class CircuitBreakerClientWithRetryAsync
implements Serializable {
    private int counterForInvokingServiceA = 0;
    private int counterForInvokingServiceB = 0;
    private int counterForInvokingServiceC = 0;

    public int getCounterForInvokingServiceA() {
        return this.counterForInvokingServiceA;
    }

    public int getCounterForInvokingServiceB() {
        return this.counterForInvokingServiceB;
    }

    public int getCounterForInvokingServiceC() {
        return this.counterForInvokingServiceC;
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={TestException.class}, maxRetries=7)
    @Asynchronous
    public Future<Connection> serviceA() {
        Connection conn = null;
        ++this.counterForInvokingServiceA;
        conn = this.connectionService();
        return CompletableFuture.completedFuture(conn);
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={TestException.class}, maxRetries=2)
    @Asynchronous
    public Future<Connection> serviceB() {
        Connection conn = null;
        ++this.counterForInvokingServiceB;
        conn = this.connectionService();
        return CompletableFuture.completedFuture(conn);
    }

    @CircuitBreaker(successThreshold=2, requestVolumeThreshold=4, failureRatio=0.75, delay=50000L)
    @Retry(retryOn={TestException.class, TimeoutException.class}, maxRetries=7, maxDuration=20000L)
    @Timeout(value=100L)
    @Asynchronous
    public Future<Connection> serviceC() {
        Object conn = null;
        ++this.counterForInvokingServiceC;
        try {
            Thread.sleep(TCKConfig.getConfig().getTimeoutInMillis(5000L));
            Assert.fail((String)"Timeout did not interrupt");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return CompletableFuture.completedFuture(conn);
    }

    @CircuitBreaker(requestVolumeThreshold=4, failureRatio=0.75, delay=1000L)
    @Retry(retryOn={CircuitBreakerOpenException.class}, maxRetries=20, delay=100L, jitter=0L)
    @Asynchronous
    public Future<String> serviceWithRetryOnCbOpen(boolean throwException) {
        if (throwException) {
            throw new TestException("Test Exception");
        }
        return CompletableFuture.completedFuture("OK");
    }

    @CircuitBreaker(requestVolumeThreshold=4, failureRatio=0.75, delay=1000L)
    @Retry(retryOn={TimeoutException.class}, maxRetries=20, delay=200L)
    @Asynchronous
    public Future<String> serviceWithRetryOnTimeout(boolean throwException) {
        if (throwException) {
            throw new TestException("Test Exception");
        }
        return CompletableFuture.completedFuture("OK");
    }

    @CircuitBreaker(requestVolumeThreshold=4, failureRatio=0.75, delay=1000L)
    @Retry(abortOn={TestException.class, CircuitBreakerOpenException.class}, maxRetries=20, delay=200L)
    @Asynchronous
    public Future<String> serviceWithRetryFailOnCbOpen(boolean throwException) {
        if (throwException) {
            throw new TestException("Test Exception");
        }
        return CompletableFuture.completedFuture("OK");
    }

    private Connection connectionService() {
        throw new TestException("Connection failed");
    }
}

