/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util;

import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.export.CollectionRegistration;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.microprofile.fault.tolerance.tck.telemetryMetrics.util.TelemetryMetricID;

@ApplicationScoped
public class InMemoryMetricReader
implements MetricReader {
    private CollectionRegistration collectionRegistration;
    private boolean isShutdown = false;

    public static InMemoryMetricReader current() {
        return (InMemoryMetricReader)CDI.current().select(InMemoryMetricReader.class, new Annotation[0]).get();
    }

    public AggregationTemporality getAggregationTemporality(InstrumentType instrumentType) {
        return AggregationTemporality.CUMULATIVE;
    }

    public void register(CollectionRegistration registration) {
        if (this.isShutdown) {
            throw new IllegalStateException("InMemoryMetricReader has been shutdown");
        }
        this.collectionRegistration = registration;
    }

    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofSuccess();
    }

    public CompletableResultCode shutdown() {
        this.collectionRegistration = null;
        this.isShutdown = true;
        return CompletableResultCode.ofSuccess();
    }

    public long readLongData(TelemetryMetricID id) {
        List<?> longData = this.getPointData(id);
        return longData.stream().mapToLong(LongPointData::getValue).sum();
    }

    protected List<?> getPointData(TelemetryMetricID id) {
        Collection allMetrics = this.collectionRegistration.collectAllMetrics();
        return allMetrics.stream().filter(md -> md.getName().equals(id.name)).flatMap(md -> md.getData().getPoints().stream()).filter(point -> id.attributes.asMap().keySet().stream().allMatch(key -> point.getAttributes().asMap().containsKey(key) && id.attributes.asMap().get(key).equals(point.getAttributes().asMap().get(key)))).collect(Collectors.toList());
    }

    public Optional<LongPointData> getGaugueMetricLatestValue(TelemetryMetricID id) {
        Collection allMetrics = this.collectionRegistration.collectAllMetrics();
        Optional<LongPointData> gague = allMetrics.stream().filter(md -> md.getName().equals(id.name)).flatMap(md -> md.getLongGaugeData().getPoints().stream()).filter(point -> id.attributes.asMap().keySet().stream().allMatch(key -> point.getAttributes().asMap().containsKey(key) && id.attributes.asMap().get(key).equals(point.getAttributes().asMap().get(key)))).sorted((pointOne, pointTwo) -> Long.compare(pointTwo.getEpochNanos(), pointOne.getEpochNanos())).findFirst();
        return gague;
    }

    public String getUnit(String metricName) {
        try {
            Collection allMetrics = this.collectionRegistration.collectAllMetrics();
            Optional<MetricData> mathcingData = allMetrics.stream().filter(md -> md.getName().equals(metricName)).findAny();
            return mathcingData.get().getUnit();
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException("Found no results for " + metricName);
        }
    }
}

