/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.report.internal.ReportPlugin;
import org.eclipse.mat.util.MessageUtil;

public final class FileUtils {
    private static DirDeleter deleterThread = new DirDeleter();

    static {
        Runtime.getRuntime().addShutdownHook(deleterThread);
    }

    private FileUtils() {
    }

    public static final void copy(InputStream in, OutputStream out) throws IOException {
        byte[] b = new byte[256];
        int i = 0;
        while ((i = in.read(b)) != -1) {
            out.write(b, 0, i);
        }
    }

    public static File createTempDirectory(String prefix, File parent) throws IOException {
        File tempFile = File.createTempFile(prefix, "", parent);
        if (!tempFile.delete()) {
            throw new IOException(tempFile.getAbsolutePath());
        }
        if (!tempFile.mkdir()) {
            throw new IOException(tempFile.getAbsolutePath());
        }
        deleterThread.add(tempFile);
        return tempFile;
    }

    public static String toFilename(String name, String extension) {
        return FileUtils.toFilename(name, "", extension);
    }

    public static String toFilename(String prefix, String suffix, String extension) {
        StringBuilder buf = new StringBuilder(prefix.length() + suffix.length() + extension.length() + 1);
        String[] stringArray = new String[]{prefix, suffix};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            int ii = 0;
            while (ii < s.length() && ii < 20) {
                char c = s.charAt(ii);
                if (Character.isLetterOrDigit(c)) {
                    buf.append(c);
                } else {
                    buf.append("_");
                }
                ++ii;
            }
            ++n2;
        }
        buf.append(".").append(extension);
        return buf.toString();
    }

    public static void unzipFile(File file) throws IOException {
        String directoryName = file.getName();
        directoryName = directoryName.substring(0, directoryName.lastIndexOf(46));
        File destinationDirectory = new File(file.getParentFile(), directoryName);
        FileUtils.unzipFile(file, destinationDirectory);
    }

    public static void unzipFile(File file, File destinationDirectory) throws IOException {
        if (!destinationDirectory.isDirectory() && !destinationDirectory.mkdir()) {
            throw new IOException(MessageUtil.format(Messages.FileUtils_FailedToMakeDirectory, destinationDirectory.getAbsolutePath()));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destinationFile = new File(destinationDirectory, entry.getName());
                if (!destinationFile.getCanonicalPath().startsWith(String.valueOf(destinationDirectory.getCanonicalPath()) + File.separator)) {
                    throw new IOException(MessageUtil.format(Messages.FileUtils_ZipSlip, entry.getName()));
                }
                File parentDirectory = destinationFile.getParentFile();
                if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
                    throw new IOException(MessageUtil.format(Messages.FileUtils_FailedToMakeDirectory, parentDirectory.getAbsolutePath()));
                }
                Throwable throwable2 = null;
                Object var10_13 = null;
                try (InputStream zipFileStream = zipFile.getInputStream(entry);){
                    Throwable throwable3 = null;
                    Object var13_18 = null;
                    try (FileOutputStream unzippedFile = new FileOutputStream(destinationFile);){
                        FileUtils.copy(zipFileStream, unzippedFile);
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    private static class DirDeleter
    extends Thread {
        private List<File> dirList = new ArrayList<File>();

        private DirDeleter() {
        }

        public synchronized void add(File dir) {
            if (this.dirList.isEmpty()) {
                ReportPlugin.onStop(this);
            }
            this.dirList.add(dir);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            DirDeleter dirDeleter = this;
            synchronized (dirDeleter) {
                for (File dir : this.dirList) {
                    this.deleteDirectory(dir);
                }
                this.dirList.clear();
            }
        }

        private void deleteDirectory(File dir) {
            if (!dir.exists()) {
                return;
            }
            File[] fileArray = dir.listFiles();
            if (fileArray != null) {
                int i = 0;
                while (i < fileArray.length) {
                    if (fileArray[i].isDirectory()) {
                        this.deleteDirectory(fileArray[i]);
                    } else if (!fileArray[i].delete()) {
                        ReportPlugin.log(2, MessageUtil.format(Messages.FileUtils_FileUtils_FailedToDeleteFile, fileArray[i].getAbsolutePath()));
                    }
                    ++i;
                }
            }
            if (!dir.delete()) {
                ReportPlugin.log(2, MessageUtil.format(Messages.FileUtils_FailedToDeleteDirectory, dir.getAbsolutePath()));
            }
        }
    }
}

