/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof.describer;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescriber;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.mat.hprof.GZIPInputStream2;
import org.eclipse.mat.hprof.describer.HprofContentDescriber;
import org.eclipse.mat.hprof.describer.Version;

public class HprofGZIPContentDescriber
implements IContentDescriber {
    private static final QualifiedName[] QUALIFIED_NAMES = new QualifiedName[]{new QualifiedName("java-heap-dump", "hprof-gzip"), new QualifiedName("org.eclipse.mat.hprof", "version"), new QualifiedName("org.eclipse.mat.hprof", "comment")};

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        try {
            GZIPInputStream2 gz = new GZIPInputStream2(contents);
            Version version = HprofContentDescriber.readVersion(gz);
            if (version != null && description != null) {
                description.setProperty(QUALIFIED_NAMES[1], (Object)version.toString());
                if (gz.comment() != null) {
                    description.setProperty(QUALIFIED_NAMES[2], (Object)gz.comment());
                }
            }
            return version != null ? 2 : 0;
        }
        catch (ZipException e) {
            return 0;
        }
    }

    public QualifiedName[] getSupportedOptions() {
        return (QualifiedName[])QUALIFIED_NAMES.clone();
    }
}

