/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.util.Iterator;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mat.ui.editor.AbstractEditorPane;
import org.eclipse.mat.ui.editor.MultiPaneEditor;

public class MultiPaneEditorSelectionProvider
implements ISelectionProvider {
    private ListenerList<ISelectionChangedListener> listeners = new ListenerList();
    private MultiPaneEditor heapEditor;

    public MultiPaneEditorSelectionProvider(MultiPaneEditor multiPageEditor) {
        this.heapEditor = multiPageEditor;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add((Object)listener);
    }

    public void fireSelectionChanged(final SelectionChangedEvent event) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener l = listener = (ISelectionChangedListener)iterator.next();
            SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
        }
    }

    public MultiPaneEditor getHeapEditor() {
        return this.heapEditor;
    }

    public ISelection getSelection() {
        ISelectionProvider selectionProvider;
        AbstractEditorPane activeEditor = this.heapEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            return selectionProvider.getSelection();
        }
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        ISelectionProvider selectionProvider;
        AbstractEditorPane activeEditor = this.heapEditor.getActiveEditor();
        if (activeEditor != null && (selectionProvider = activeEditor.getSite().getSelectionProvider()) != null) {
            selectionProvider.setSelection(selection);
        }
    }
}

