/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.util;

import java.util.BitSet;
import org.eclipse.mat.parser.internal.util.IntStack;

public class LimitedValueIntStore {
    private static int SIZE_SZ = 4;
    private static int PREV_SZ = 25;
    private static int END_MARKER = -1 >>> 32 - PREV_SZ;
    private static int NUM_VALUES = 15;
    int[] data;
    int numBits = 0;
    int size;
    int entrySize;
    BitSet used;
    int usedCount;

    public LimitedValueIntStore(int maxValue, int initialCapacity) {
        while ((double)maxValue > Math.pow(2.0, this.numBits)) {
            ++this.numBits;
        }
        this.entrySize = SIZE_SZ + PREV_SZ + NUM_VALUES * this.numBits;
        this.size = initialCapacity;
        int length = this.size * this.entrySize / 32;
        length = length % 32 == 0 ? length : length + 32 - length % 32;
        this.data = new int[length];
        this.used = new BitSet(this.size);
    }

    public final int add(int index, int value) {
        int count = this.readBits(index * this.entrySize, SIZE_SZ);
        if (count == NUM_VALUES) {
            int newAddr = this.create();
            this.setBits(newAddr * this.entrySize + SIZE_SZ, PREV_SZ, index);
            index = newAddr;
            count = 0;
        }
        this.setBits(index * this.entrySize, SIZE_SZ, count + 1);
        this.setBits(index * this.entrySize + SIZE_SZ + PREV_SZ + count * this.numBits, this.numBits, value);
        return index;
    }

    public final int[] get(int index) {
        IntStack stack = new IntStack();
        int prev = index;
        do {
            stack.push(prev);
        } while ((prev = this.readBits(prev * this.entrySize + SIZE_SZ, PREV_SZ)) != END_MARKER);
        int lastSize = this.readBits(index * this.entrySize, SIZE_SZ);
        int[] result = new int[(stack.size() - 1) * NUM_VALUES + lastSize];
        int i = 0;
        while (stack.size() > 0) {
            int current = stack.pop();
            lastSize = this.readBits(current * this.entrySize, SIZE_SZ);
            int j = 0;
            while (j < lastSize) {
                result[i++] = this.readBits(current * this.entrySize + SIZE_SZ + PREV_SZ + j * this.numBits, this.numBits);
                ++j;
            }
        }
        return result;
    }

    public final int create() {
        if (this.usedCount == this.size) {
            int[] newData = new int[this.data.length * 2];
            System.arraycopy(this.data, 0, newData, 0, this.data.length);
            this.data = newData;
            this.size *= 2;
        }
        int index = this.used.nextClearBit(0);
        this.used.set(index);
        ++this.usedCount;
        this.setBits(index * this.entrySize, SIZE_SZ, 0);
        this.setBits(index * this.entrySize + SIZE_SZ, PREV_SZ, END_MARKER);
        return index;
    }

    public final void dispose(int index) {
        do {
            this.used.clear(index);
            --this.usedCount;
        } while ((index = this.readBits(index * this.entrySize + SIZE_SZ, PREV_SZ)) != END_MARKER);
    }

    private int readBits(int pos, int length) {
        int idx = pos >>> 5;
        int off = pos & 0x1F;
        if (off + length <= 32) {
            return this.data[idx] << off >>> 32 - length;
        }
        return this.data[idx] << off >>> 32 - length | this.data[idx + 1] >>> 64 - length - off;
    }

    private void setBits(int pos, int length, int value) {
        int idx = pos >>> 5;
        int off = pos & 0x1F;
        if (off + length <= 32) {
            int clear = -1;
            clear <<= off;
            clear >>>= off;
            clear >>>= 32 - off - length;
            clear <<= 32 - off - length;
            int n = idx;
            this.data[n] = this.data[n] & (clear ^= 0xFFFFFFFF);
            int n2 = idx;
            this.data[n2] = this.data[n2] | (value <<= 32 - off - length);
        } else {
            int tmp = this.data[idx];
            tmp >>>= 32 - off;
            tmp <<= 32 - off;
            this.data[idx] = tmp |= value >>> length - (32 - off);
            tmp = this.data[idx + 1];
            tmp <<= length - (32 - off);
            tmp >>>= length - (32 - off);
            this.data[idx + 1] = tmp |= value << 32 - (length - (32 - off));
        }
    }
}

