/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.internal.snapshot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.RecursiveAction;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.BitField;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.internal.Messages;
import org.eclipse.mat.snapshot.ExcludedReferencesDescriptor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.NamedReference;
import org.eclipse.mat.snapshot.model.ObjectReference;
import org.eclipse.mat.util.IProgressListener;

public class ObjectMarker {
    int[] roots;
    boolean[] bits;
    IIndexReader.IOne2ManyIndex outbound;
    IProgressListener progressListener;
    final int LEVELS_RUN_INLINE = 4;

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, IProgressListener progressListener) {
        this(roots, bits, outbound, 0L, progressListener);
    }

    public ObjectMarker(int[] roots, boolean[] bits, IIndexReader.IOne2ManyIndex outbound, long outboundLength, IProgressListener progressListener) {
        this.roots = roots;
        this.bits = bits;
        this.outbound = outbound;
        this.progressListener = progressListener;
    }

    public int markSingleThreaded() {
        int before = this.countMarked();
        try {
            this.markMultiThreaded(1);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        int after = this.countMarked();
        return after - before;
    }

    public void markMultiThreaded(int threads) throws InterruptedException {
        List<FjObjectMarker> rootTasks = IntStream.of(this.roots).filter(r -> !this.bits[r]).mapToObj(r -> new FjObjectMarker(r, this.bits, true)).collect(Collectors.toList());
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootTasks.size());
        ForkJoinPool pool = new ForkJoinPool(threads);
        rootTasks.forEach(r -> pool.execute((ForkJoinTask<?>)r));
        rootTasks.forEach(ForkJoinTask::join);
        pool.shutdown();
        while (!pool.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
        }
        this.progressListener.done();
    }

    int countMarked() {
        int marked = 0;
        boolean[] blArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                ++marked;
            }
            ++n2;
        }
        return marked;
    }

    public int markSingleThreaded(ExcludedReferencesDescriptor[] excludeSets, ISnapshot snapshot) throws SnapshotException, IProgressListener.OperationCanceledException {
        int n;
        int n2;
        int[] nArray;
        BitField excludeObjectsBF = new BitField(snapshot.getSnapshotInfo().getNumberOfObjects());
        ExcludedReferencesDescriptor[] excludedReferencesDescriptorArray = excludeSets;
        int n3 = excludeSets.length;
        int n4 = 0;
        while (n4 < n3) {
            ExcludedReferencesDescriptor set = excludedReferencesDescriptorArray[n4];
            nArray = set.getObjectIds();
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                int k = nArray[n];
                excludeObjectsBF.set(k);
                ++n;
            }
            ++n4;
        }
        int count = 0;
        int rootsToProcess = 0;
        int size = 0;
        int[] data = new int[10240];
        nArray = this.roots;
        n2 = this.roots.length;
        n = 0;
        while (n < n2) {
            int rootId = nArray[n];
            if (!this.bits[rootId]) {
                if (size == data.length) {
                    int[] newArr = new int[data.length << 1];
                    System.arraycopy(data, 0, newArr, 0, data.length);
                    data = newArr;
                }
                data[size++] = rootId;
                this.bits[rootId] = true;
                ++count;
                ++rootsToProcess;
            }
            ++n;
        }
        this.progressListener.beginTask(Messages.ObjectMarker_MarkingObjects, rootsToProcess);
        ArrayList<NamedReference> refCache = new ArrayList<NamedReference>();
        while (size > 0) {
            int current = data[--size];
            if (size <= rootsToProcess) {
                --rootsToProcess;
                this.progressListener.worked(1);
                if (this.progressListener.isCanceled()) {
                    throw new IProgressListener.OperationCanceledException();
                }
            }
            refCache.clear();
            int[] nArray2 = this.outbound.get(current);
            int n5 = nArray2.length;
            int n6 = 0;
            while (n6 < n5) {
                int child = nArray2[n6];
                if (!this.bits[child] && !this.refersOnlyThroughExcluded(current, child, excludeSets, excludeObjectsBF, refCache, snapshot)) {
                    if (size == data.length) {
                        int[] newArr = new int[data.length << 1];
                        System.arraycopy(data, 0, newArr, 0, data.length);
                        data = newArr;
                    }
                    data[size++] = child;
                    this.bits[child] = true;
                    if (++count % 10000 == 0 && this.progressListener.isCanceled()) {
                        throw new IProgressListener.OperationCanceledException();
                    }
                }
                ++n6;
            }
        }
        this.progressListener.done();
        return count;
    }

    /*
     * Unable to fully structure code
     */
    private boolean refersOnlyThroughExcluded(int referrerId, int referentId, ExcludedReferencesDescriptor[] excludeSets, BitField excludeObjectsBF, List<NamedReference> refCache, ISnapshot snapshot) throws SnapshotException {
        block13: {
            block12: {
                if (!excludeObjectsBF.get(referrerId)) {
                    return false;
                }
                excludeFields = null;
                var11_8 = excludeSets;
                var10_10 = excludeSets.length;
                var9_11 = 0;
                while (var9_11 < var10_10) {
                    set = var11_8[var9_11];
                    if (set.contains(referrerId)) {
                        excludeFields = set.getFields();
                        break;
                    }
                    ++var9_11;
                }
                if (excludeFields == null) {
                    return true;
                }
                referrerObject = snapshot.getObject(referrerId);
                referentAddr = snapshot.mapIdToAddress(referentId);
                minsort = 10;
                if (refCache.isEmpty()) {
                    refs = referrerObject.getOutboundReferences();
                    refCache.addAll(refs);
                    v0 = sorted = refCache.size() >= 10;
                    if (sorted) {
                        refCache.sort(CompObjectReference.INSTANCE);
                    }
                } else {
                    v1 = sorted = refCache.size() >= 10;
                }
                if (!sorted) break block12;
                idx = Collections.binarySearch(refCache, new ObjectReference(snapshot, referentAddr), CompObjectReference.INSTANCE);
                if (idx >= 0) ** GOTO lbl33
                return true;
lbl-1000:
                // 1 sources

                {
                    --idx;
lbl33:
                    // 2 sources

                    ** while (idx > 0 && refCache.get((int)(idx - 1)).getObjectAddress() == referentAddr)
                }
lbl34:
                // 1 sources

                break block13;
            }
            idx = 0;
        }
        i = idx;
        while (i < refCache.size()) {
            reference = refCache.get(i);
            if (referentAddr == reference.getObjectAddress()) {
                if (!excludeFields.contains(reference.getName())) {
                    return false;
                }
            } else if (sorted) break;
            ++i;
        }
        return true;
    }

    private static final class CompObjectReference
    implements Comparator<ObjectReference> {
        static CompObjectReference INSTANCE = new CompObjectReference();

        private CompObjectReference() {
        }

        @Override
        public int compare(ObjectReference o1, ObjectReference o2) {
            return Long.compare(o1.getObjectAddress(), o2.getObjectAddress());
        }
    }

    public class FjObjectMarker
    extends RecursiveAction {
        final int position;
        final boolean[] visited;
        final boolean topLevel;

        private FjObjectMarker(int position, boolean[] visited, boolean topLevel) {
            visited[position] = true;
            this.position = position;
            this.visited = visited;
            this.topLevel = topLevel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void compute() {
            if (ObjectMarker.this.progressListener.isCanceled()) {
                return;
            }
            this.compute(this.position, 4);
            if (this.topLevel) {
                IProgressListener iProgressListener = ObjectMarker.this.progressListener;
                synchronized (iProgressListener) {
                    ObjectMarker.this.progressListener.worked(1);
                }
            }
        }

        void compute(int outboundPosition, int levelsLeft) {
            int[] process;
            int[] nArray = process = ObjectMarker.this.outbound.get(outboundPosition);
            int n = process.length;
            int n2 = 0;
            while (n2 < n) {
                int r = nArray[n2];
                if (!this.visited[r]) {
                    this.visited[r] = true;
                    if (levelsLeft <= 0) {
                        new FjObjectMarker(r, this.visited, false).fork();
                    } else {
                        this.compute(r, levelsLeft - 1);
                    }
                }
                ++n2;
            }
        }
    }
}

