/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.hnsw;

import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.util.hnsw.NeighborArray;
import org.apache.lucene.util.hnsw.OnHeapHnswGraph;

class HnswLock {
    private static final int NUM_LOCKS = 512;
    private final ReentrantReadWriteLock[] locks;
    private final OnHeapHnswGraph graph;

    HnswLock(OnHeapHnswGraph graph) {
        this.graph = graph;
        this.locks = new ReentrantReadWriteLock[512];
        for (int i = 0; i < 512; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    LockedRow read(int level, int node) {
        int lockid = Objects.hash(level, node) % 512;
        ReentrantReadWriteLock.ReadLock lock = this.locks[lockid].readLock();
        lock.lock();
        return new LockedRow(this.graph.getNeighbors(level, node), lock);
    }

    LockedRow write(int level, int node) {
        int lockid = Objects.hash(level, node) % 512;
        ReentrantReadWriteLock.WriteLock lock = this.locks[lockid].writeLock();
        lock.lock();
        return new LockedRow(this.graph.getNeighbors(level, node), lock);
    }

    static class LockedRow
    implements Closeable {
        final Lock lock;
        final NeighborArray row;

        LockedRow(NeighborArray row, Lock lock) {
            this.lock = lock;
            this.row = row;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

