/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import org.eclipse.birt.core.archive.compound.ArchiveFile;
import org.eclipse.birt.core.archive.compound.IArchiveFile;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.fs.IFile;
import org.eclipse.birt.core.fs.IFileSystemFactory;
import org.eclipse.birt.core.fs.LocalFile;

public class FileSystemFactory
implements IFileSystemFactory {
    private static volatile IFileSystemFactory instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IFileSystemFactory getInstance() {
        if (instance != null) return instance;
        Class<FileSystemFactory> clazz = FileSystemFactory.class;
        synchronized (FileSystemFactory.class) {
            if (instance != null) return instance;
            Object factory = Platform.createFactoryObject(IFileSystemFactory.EXTENSION_FILE_SYSTEM_FACTORY);
            instance = factory instanceof IFileSystemFactory ? (IFileSystemFactory)factory : new FileSystemFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public IFile getFile(String fileName) {
        return new LocalFile(new File(fileName));
    }

    @Override
    public IFile getFile(URI uri) {
        return new LocalFile(uri);
    }

    @Override
    public IArchiveFile createArchiveFile(String systemId, String fileName, String mode, IFile externalFile) throws IOException {
        return new ArchiveFile(systemId, fileName, mode);
    }
}

