/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.compound.v3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Collections;
import java.util.TreeMap;
import org.eclipse.birt.core.archive.compound.v3.Ext2Entry;
import org.eclipse.birt.core.archive.compound.v3.Ext2File;
import org.eclipse.birt.core.archive.compound.v3.Ext2FileSystem;
import org.eclipse.birt.core.archive.compound.v3.PrefixedIterable;

public class EntryTable {
    private final Ext2FileSystem fs;
    private final TreeMap<String, Ext2Entry> entries;
    private boolean dirty;

    EntryTable(Ext2FileSystem fs) {
        this.fs = fs;
        this.entries = new TreeMap();
        this.dirty = true;
    }

    void read() throws IOException {
        try (Ext2File file = new Ext2File(this.fs, 3, false);){
            byte[] bytes = new byte[(int)file.length()];
            file.read(bytes, 0, bytes.length);
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try {
                    try {
                        while (true) {
                            String name = in.readUTF();
                            int inode = in.readInt();
                            this.entries.put(name, new Ext2Entry(name, inode));
                        }
                    }
                    catch (Throwable throwable2) {
                        if (in != null) {
                            in.close();
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    throw throwable;
                }
            }
            catch (EOFException eOFException) {
            }
        }
        this.dirty = false;
    }

    void write() throws IOException {
        if (!this.dirty) {
            return;
        }
        this.dirty = false;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(buffer);
        for (Ext2Entry entry : this.entries.values()) {
            out.writeUTF(entry.name);
            out.writeInt(entry.inode);
        }
        try (Ext2File file = new Ext2File(this.fs, 3, false);){
            byte[] bytes = buffer.toByteArray();
            file.write(bytes, 0, bytes.length);
            file.setLength(bytes.length);
        }
    }

    Ext2Entry getEntry(String name) {
        return this.entries.get(name);
    }

    Ext2Entry removeEntry(String name) {
        Ext2Entry entry = this.entries.remove(name);
        if (entry != null) {
            this.dirty = true;
        }
        return entry;
    }

    void addEntry(Ext2Entry entry) {
        this.dirty = true;
        this.entries.put(entry.name, entry);
    }

    Iterable<String> listAllEntries() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    Iterable<String> listEntries(String fromName) {
        return PrefixedIterable.filteredByPrefix(this.entries, fromName);
    }

    void clear() {
        this.dirty = true;
        this.entries.clear();
    }
}

