/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.hprof;

import java.io.IOException;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayLong;
import org.eclipse.mat.parser.IPreliminaryIndex;
import org.eclipse.mat.parser.index.IIndexReader;
import org.eclipse.mat.parser.model.ClassImpl;
import org.eclipse.mat.parser.model.XSnapshotInfo;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.util.IProgressListener;

public interface IHprofParserHandler {
    public static final String IDENTIFIER_SIZE = "ID_SIZE";
    public static final String CREATION_DATE = "CREATION_DATE";
    public static final String VERSION = "VERSION";
    public static final String REFERENCE_SIZE = "REF_SIZE";
    public static final String STREAM_LENGTH = "LENGTH";
    public static final String HEAP_POSITION = "HEAP_POS";

    public void beforePass1(XSnapshotInfo var1) throws IOException;

    public void beforePass2(IProgressListener var1) throws IOException, SnapshotException;

    public IIndexReader.IOne2LongIndex fillIn(IPreliminaryIndex var1, IProgressListener var2) throws IOException;

    public void cancel();

    public void addProperty(String var1, String var2) throws IOException;

    public void addGCRoot(long var1, long var3, int var5) throws IOException;

    public void addClass(ClassImpl var1, long var2, int var4, int var5) throws IOException;

    public void addObject(HeapObject var1) throws IOException;

    public void reportInstanceWithClass(long var1, long var3, long var5, int var7);

    public void reportInstanceOfObjectArray(long var1, long var3, long var5);

    public void reportInstanceOfPrimitiveArray(long var1, long var3, int var5);

    public int getIdentifierSize();

    public IClass lookupClass(long var1);

    public IClass lookupClassByName(String var1, boolean var2);

    public IClass lookupClassByIndex(int var1);

    public IClass lookupPrimitiveArrayClassByType(byte var1);

    public List<IClass> resolveClassHierarchy(long var1);

    public int mapAddressToId(long var1);

    public XSnapshotInfo getSnapshotInfo();

    public long getObjectArrayHeapSize(ClassImpl var1, int var2);

    public long getPrimitiveArrayHeapSize(byte var1, int var2);

    public static class HeapObject {
        public long objectAddress;
        public ClassImpl clazz;
        public long usedHeapSize;
        public ArrayLong references;
        public boolean isObjectArray = false;
        public boolean isPrimitiveArray = false;
        public long filePosition;
        public long classIdOrElementType;
        public int arraySize;
        public long[] ids;
        public byte[] instanceData;
        public int idSize;

        public static HeapObject forPrimitiveArray(long objectAddress, byte elementType, int arraySize, long filePosition) {
            HeapObject o = new HeapObject(1);
            o.objectAddress = objectAddress;
            o.isPrimitiveArray = true;
            o.classIdOrElementType = elementType;
            o.arraySize = arraySize;
            o.filePosition = filePosition;
            return o;
        }

        public static HeapObject forObjectArray(long objectAddress, long classID, int arraySize, long[] ids, long filePosition) {
            HeapObject o = new HeapObject(1 + ids.length);
            o.objectAddress = objectAddress;
            o.isObjectArray = true;
            o.classIdOrElementType = classID;
            o.arraySize = arraySize;
            o.filePosition = filePosition;
            o.ids = ids;
            return o;
        }

        public static HeapObject forInstance(long objectAddress, long classID, byte[] instanceData, long filePosition, int idSize) {
            int estSize = Math.min(10, 1 + instanceData.length / idSize);
            HeapObject o = new HeapObject(estSize);
            o.objectAddress = objectAddress;
            o.classIdOrElementType = classID;
            o.instanceData = instanceData;
            o.filePosition = filePosition;
            o.idSize = idSize;
            return o;
        }

        public HeapObject() {
            this.references = new ArrayLong();
        }

        public HeapObject(int refs) {
            this.references = new ArrayLong(refs);
        }

        public HeapObject(long objectAddress, ClassImpl clazz, long usedHeapSize) {
            this(0);
            this.objectAddress = objectAddress;
            this.clazz = clazz;
            this.usedHeapSize = usedHeapSize;
        }
    }
}

