/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ImageSourceType implements Enumerator
{
    STATIC(0, "static", "static"),
    REPORT(1, "report", "report"),
    FILE(2, "file", "file");

    public static final int STATIC_VALUE = 0;
    public static final int REPORT_VALUE = 1;
    public static final int FILE_VALUE = 2;
    private static final ImageSourceType[] VALUES_ARRAY;
    public static final List<ImageSourceType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ImageSourceType[]{STATIC, REPORT, FILE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ImageSourceType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImageSourceType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImageSourceType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ImageSourceType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ImageSourceType get(int value) {
        switch (value) {
            case 0: {
                return STATIC;
            }
            case 1: {
                return REPORT;
            }
            case 2: {
                return FILE;
            }
        }
        return null;
    }

    private ImageSourceType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

