/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.dtfj;

import com.ibm.dtfj.image.CorruptData;
import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.Image;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageStackFrame;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.java.JavaMonitor;
import com.ibm.dtfj.java.JavaObject;
import com.ibm.dtfj.java.JavaRuntime;
import com.ibm.dtfj.java.JavaThread;
import com.ibm.icu.text.DecimalFormat;
import java.math.BigInteger;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.dtfj.DTFJIndexBuilder;
import org.eclipse.mat.dtfj.Messages;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.IThreadDetailsResolver;
import org.eclipse.mat.snapshot.extension.IThreadInfo;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

class ThreadDetailsResolver1
implements IThreadDetailsResolver {
    DecimalFormat hex = new HexFormat();

    ThreadDetailsResolver1() {
        JavaRuntime.class.getName();
    }

    private Image getLock(IThreadInfo thread) throws SnapshotException {
        IObject object = thread.getThreadObject();
        return (Image)object.getSnapshot().getSnapshotAddons(Image.class);
    }

    public Column[] getColumns() {
        return new Column[]{new Column(Messages.ThreadDetailsResolver_DTFJ_Name), new Column(Messages.ThreadDetailsResolver_JNIEnv, Long.class).noTotals().formatting((Format)this.hex), new Column(Messages.ThreadDetailsResolver_Priority, Integer.class).noTotals(), new Column(Messages.ThreadDetailsResolver_State), new Column(Messages.ThreadDetailsResolver_State_value, Integer.class).noTotals().formatting((Format)this.hex), new Column(Messages.ThreadDetailsResolver_Native_id)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complementShallow(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        Image imageLock = this.getLock(thread);
        if (imageLock == null) {
            return;
        }
        Image image = imageLock;
        synchronized (image) {
            JavaThread jt = this.getJavaThread(thread, listener);
            if (jt != null) {
                Column[] cols = this.getColumns();
                try {
                    thread.setValue(cols[0], (Object)jt.getName());
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
                try {
                    ImagePointer ip = jt.getJNIEnv();
                    if (ip != null) {
                        thread.setValue(cols[1], (Object)ip.getAddress());
                    }
                }
                catch (CorruptDataException ip) {
                    // empty catch block
                }
                try {
                    thread.setValue(cols[2], (Object)jt.getPriority());
                }
                catch (CorruptDataException ip) {
                    // empty catch block
                }
                try {
                    int state = jt.getState();
                    String stateName = this.printableState(state);
                    thread.setValue(cols[3], (Object)stateName);
                    thread.setValue(cols[4], (Object)state);
                }
                catch (CorruptDataException state) {
                    // empty catch block
                }
                try {
                    ImageThread it = jt.getImageThread();
                    String id = it.getID();
                    thread.setValue(cols[5], (Object)id);
                }
                catch (DataUnavailable dataUnavailable) {
                }
                catch (CorruptDataException corruptDataException) {
                    // empty catch block
                }
            }
        }
    }

    private String printableState(int state) {
        ArrayList<String> al = new ArrayList<String>();
        if ((state & 1) != 0) {
            al.add(Messages.ThreadDetailsResolver_alive);
        }
        if ((state & 0x400) != 0) {
            al.add(Messages.ThreadDetailsResolver_blocked_on_monitor_enter);
        }
        if ((state & 0x400000) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_native);
        }
        if ((state & 0x100) != 0) {
            al.add(Messages.ThreadDetailsResolver_in_object_wait);
        }
        if ((state & 0x200000) != 0) {
            al.add(Messages.ThreadDetailsResolver_interrupted);
        }
        if ((state & 0x200) != 0) {
            al.add(Messages.ThreadDetailsResolver_parked);
        }
        if ((state & 4) != 0) {
            al.add(Messages.ThreadDetailsResolver_runnable);
        }
        if ((state & 0x40) != 0) {
            al.add(Messages.ThreadDetailsResolver_sleeping);
        }
        if ((state & 0x100000) != 0) {
            al.add(Messages.ThreadDetailsResolver_suspended);
        }
        if ((state & 2) != 0) {
            al.add(Messages.ThreadDetailsResolver_terminated);
        }
        if ((state & 0x10000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor1);
        }
        if ((state & 0x20000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor2);
        }
        if ((state & 0x40000000) != 0) {
            al.add(Messages.ThreadDetailsResolver_vendor3);
        }
        if ((state & 0x80) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting);
        }
        if ((state & 0x10) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_indefinitely);
        }
        if ((state & 0x20) != 0) {
            al.add(Messages.ThreadDetailsResolver_waiting_with_timeout);
        }
        return al.toString();
    }

    private JavaThread getJavaThread(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        IObject object = thread.getThreadObject();
        JavaRuntime jr = (JavaRuntime)object.getSnapshot().getSnapshotAddons(JavaRuntime.class);
        if (jr != null) {
            Iterator it = jr.getThreads();
            while (it.hasNext()) {
                JavaThread jt;
                long addr;
                Object o = it.next();
                if (!(o instanceof JavaThread) || (addr = DTFJIndexBuilder.getThreadAddress(jt = (JavaThread)o, listener)) != object.getObjectAddress()) continue;
                return jt;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complementDeep(IThreadInfo thread, IProgressListener listener) throws SnapshotException {
        Image imageLock = this.getLock(thread);
        if (imageLock == null) {
            return;
        }
        Image image = imageLock;
        synchronized (image) {
            this.complementShallow(thread, listener);
            JavaThread jt = this.getJavaThread(thread, listener);
            if (jt != null) {
                try {
                    ImageThread it = jt.getImageThread();
                    StringBuilder sb = new StringBuilder();
                    Iterator sfs = it.getStackFrames();
                    while (sfs.hasNext()) {
                        Object o = sfs.next();
                        if (!(o instanceof ImageStackFrame)) continue;
                        ImageStackFrame sf = (ImageStackFrame)o;
                        try {
                            sb.append(sf.getProcedureName());
                        }
                        catch (CorruptDataException e) {
                            sb.append(e.toString());
                        }
                        sb.append('\n');
                    }
                    TextResult tr = new TextResult(sb.toString());
                    thread.addDetails(Messages.ThreadDetailsResolver_Native_stack, (IResult)tr);
                }
                catch (DataUnavailable it) {
                }
                catch (CorruptDataException it) {
                    // empty catch block
                }
                try {
                    ISnapshot snapshot = thread.getThreadObject().getSnapshot();
                    JavaObject bo = null;
                    try {
                        bo = jt.getBlockingObject();
                    }
                    catch (DataUnavailable tr) {
                    }
                    catch (CorruptDataException tr) {
                        // empty catch block
                    }
                    long addr = 0L;
                    ArrayInt blocking = new ArrayInt();
                    if (bo != null) {
                        addr = bo.getID().getAddress();
                        int id = snapshot.mapAddressToId(addr);
                        blocking.add(id);
                    }
                    ArrayInt owned = new ArrayInt();
                    ArrayInt owners = new ArrayInt();
                    ArrayInt enters = new ArrayInt();
                    ArrayInt waits = new ArrayInt();
                    JavaRuntime jr = (JavaRuntime)snapshot.getSnapshotAddons(JavaRuntime.class);
                    if (jr != null) {
                        Iterator it = jr.getMonitors();
                        while (it.hasNext()) {
                            long addr2;
                            JavaMonitor jm;
                            JavaObject jo;
                            Object o = it.next();
                            if (o instanceof CorruptData || !(o instanceof JavaMonitor) || (jo = (jm = (JavaMonitor)o).getObject()) == null) continue;
                            JavaThread jth = jm.getOwner();
                            if (jth != null && (addr2 = jth.getObject().getID().getAddress()) == thread.getThreadObject().getObjectAddress()) {
                                long addr3 = jo.getID().getAddress();
                                try {
                                    int id2 = snapshot.mapAddressToId(addr3);
                                    owned.add(id2);
                                }
                                catch (SnapshotException snapshotException) {
                                    // empty catch block
                                }
                            }
                            if (!jo.equals((Object)bo)) continue;
                            JavaThread jth2 = jm.getOwner();
                            if (jth2 != null) {
                                long addr22 = jth2.getObject().getID().getAddress();
                                try {
                                    int id2 = snapshot.mapAddressToId(addr22);
                                    owners.add(id2);
                                }
                                catch (SnapshotException id2) {
                                    // empty catch block
                                }
                            }
                            Iterator it2 = jm.getEnterWaiters();
                            while (it2.hasNext()) {
                                Object o2 = it2.next();
                                if (o2 instanceof CorruptData || !(o2 instanceof JavaThread)) continue;
                                jth = (JavaThread)o2;
                                long addr23 = jth.getObject().getID().getAddress();
                                try {
                                    int id2 = snapshot.mapAddressToId(addr23);
                                    enters.add(id2);
                                }
                                catch (SnapshotException id2) {
                                    // empty catch block
                                }
                            }
                            it2 = jm.getNotifyWaiters();
                            while (it2.hasNext()) {
                                Object o2 = it2.next();
                                if (o2 instanceof CorruptData || !(o2 instanceof JavaThread)) continue;
                                jth = (JavaThread)o2;
                                long addr24 = jth.getObject().getID().getAddress();
                                try {
                                    int id2 = snapshot.mapAddressToId(addr24);
                                    waits.add(id2);
                                }
                                catch (SnapshotException snapshotException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    ObjectListResult.Outbound res2 = new ObjectListResult.Outbound(snapshot, owned.toArray());
                    thread.addDetails(Messages.ThreadDetailsResolver_OwnerMonitors, (IResult)res2);
                    if (!blocking.isEmpty()) {
                        res2 = new ObjectListResult.Outbound(snapshot, blocking.toArray());
                        thread.addDetails(Messages.ThreadDetailsResolver_ThreadBlockedOn, (IResult)res2);
                        res2 = new ObjectListResult.Outbound(snapshot, owners.toArray());
                        thread.addDetails(Messages.ThreadDetailsResolver_CurrentOwner, (IResult)res2);
                        res2 = new ObjectListResult.Outbound(snapshot, enters.toArray());
                        thread.addDetails(Messages.ThreadDetailsResolver_WaitEnterThreads, (IResult)res2);
                        res2 = new ObjectListResult.Outbound(snapshot, waits.toArray());
                        thread.addDetails(Messages.ThreadDetailsResolver_WaitNotifyThreads, (IResult)res2);
                    }
                }
                catch (CorruptDataException corruptDataException) {
                }
                catch (SnapshotException snapshotException) {
                    // empty catch block
                }
            }
        }
    }

    static class HexFormat
    extends DecimalFormat {
        private static final String JAVA_HEX_PATTERN = "[-]?(0x|0X|#)\\p{XDigit}+";
        private static final String JAVA_LONG_PATTERN = "[+-]?((0x|0X|#)(\\p{XDigit}+))|(\\p{Digit}+)";
        private static final long serialVersionUID = -420084952258370133L;

        HexFormat() {
        }

        public StringBuffer format(long val, StringBuffer buf, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(buf.length());
            buf.append("0x").append(Long.toHexString(val));
            fieldPosition.setEndIndex(buf.length());
            return buf;
        }

        public StringBuffer format(double val, StringBuffer buf, FieldPosition fieldPosition) {
            return this.format((long)val, buf, fieldPosition);
        }

        public Number parse(String text) throws ParseException {
            if (!text.matches("[-]?(0x|0X|#)\\p{XDigit}+.*")) {
                return super.parse(text);
            }
            ParsePosition p = new ParsePosition(0);
            Number l = this.parse(text, p);
            if (l == null || p.getIndex() == 0) {
                throw new ParseException(text, 0);
            }
            return l;
        }

        public Number parse(String text, ParsePosition p) {
            if (!text.matches("[-]?(0x|0X|#)\\p{XDigit}+.*")) {
                return super.parse(text, p);
            }
            int start = p.getIndex();
            String text1 = text.substring(start).replaceFirst("(([+-]?((0x|0X|#)(\\p{XDigit}+))|(\\p{Digit}+)).*)", "$2");
            try {
                long l = Long.decode(text1);
                p.setIndex(start + text1.length());
                return l;
            }
            catch (NumberFormatException e) {
                String text2 = text1.replaceFirst(JAVA_LONG_PATTERN, "$3");
                if (text2.length() > 0) {
                    try {
                        BigInteger b1 = new BigInteger(text2, 16);
                        if (text1.startsWith("-")) {
                            b1 = b1.negate();
                        }
                        p.setIndex(start + text1.length());
                        return b1.longValue();
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
                text2 = text1.replaceFirst(JAVA_LONG_PATTERN, "$4");
                if (text2.length() > 0) {
                    try {
                        BigInteger b1 = new BigInteger(text2, 10);
                        if (text1.startsWith("-")) {
                            b1 = b1.negate();
                        }
                        p.setIndex(start + text1.length());
                        return b1.longValue();
                    }
                    catch (NumberFormatException e2) {
                        return null;
                    }
                }
                return null;
            }
        }
    }
}

