/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.ide.undo;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.IResourceChangeDescriptionFactory;
import org.eclipse.core.resources.undo.snapshot.IResourceSnapshot;
import org.eclipse.core.resources.undo.snapshot.ResourceSnapshotFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.ide.undo.AbstractCopyOrMoveResourcesOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public class CopyResourcesOperation
extends AbstractCopyOrMoveResourcesOperation {
    IResource[] originalResources;
    IResourceSnapshot<? extends IResource>[] snapshotResourceDescriptions;

    public CopyResourcesOperation(IResource resource, IPath newPath, String label) {
        super(new IResource[]{resource}, new IPath[]{newPath}, label);
        this.setOriginalResources(new IResource[]{resource});
    }

    public CopyResourcesOperation(IResource[] resources, IPath destinationPath, String label) {
        super(resources, destinationPath, label);
        this.setOriginalResources(this.resources);
    }

    public CopyResourcesOperation(IResource[] resources, IPath[] destinationPaths, String label) {
        super(resources, destinationPaths, label);
        this.setOriginalResources(this.resources);
    }

    @Override
    protected void doExecute(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        this.copy(monitor, uiInfo);
    }

    protected void copy(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(this.resources.length + (this.resourceDescriptions != null ? this.resourceDescriptions.length : 0)));
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        ArrayList<IResource> resourcesAtDestination = new ArrayList<IResource>();
        ArrayList<IResourceSnapshot<? extends IResource>> overwrittenResources = new ArrayList<IResourceSnapshot<? extends IResource>>();
        int i = 0;
        while (i < this.resources.length) {
            IResourceSnapshot<? extends IResource>[] overwrites = WorkspaceUndoUtil.copy(new IResource[]{this.resources[i]}, this.getDestinationPath(this.resources[i], i), resourcesAtDestination, (IProgressMonitor)subMonitor.split(1), uiInfo, true, this.fCreateGroups, this.fCreateLinks, this.fRelativeToVariable);
            overwrittenResources.addAll(Arrays.asList(overwrites));
            ++i;
        }
        if (this.resourceDescriptions != null) {
            IResourceSnapshot[] iResourceSnapshotArray = this.resourceDescriptions;
            int n = this.resourceDescriptions.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceSnapshot resourceDescription = iResourceSnapshotArray[n2];
                if (resourceDescription != null) {
                    resourceDescription.createResource((IProgressMonitor)subMonitor.split(1));
                }
                ++n2;
            }
        }
        this.setResourceDescriptions(overwrittenResources.toArray(new IResourceSnapshot[overwrittenResources.size()]));
        this.setTargetResources(resourcesAtDestination.toArray(new IResource[resourcesAtDestination.size()]));
    }

    @Override
    protected void doUndo(IProgressMonitor monitor, IAdaptable uiInfo) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        subMonitor.setTaskName(UndoMessages.AbstractResourcesOperation_CopyingResourcesProgress);
        WorkspaceUndoUtil.delete(this.resources, (IProgressMonitor)subMonitor.split(1), uiInfo, true);
        WorkspaceUndoUtil.recreate(this.resourceDescriptions, (IProgressMonitor)subMonitor.split(1), uiInfo);
        this.setResourceDescriptions(new IResourceSnapshot[0]);
        this.setTargetResources(this.originalResources);
        monitor.done();
    }

    @Override
    protected boolean updateResourceChangeDescriptionFactory(IResourceChangeDescriptionFactory factory, int operation) {
        boolean update = false;
        if (operation == UNDO) {
            IResource[] iResourceArray = this.resources;
            int n = this.resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                update = true;
                factory.delete(resource);
                ++n2;
            }
            iResourceArray = this.resourceDescriptions;
            n = this.resourceDescriptions.length;
            n2 = 0;
            while (n2 < n) {
                IResource resourceDescription = iResourceArray[n2];
                if (resourceDescription != null) {
                    update = true;
                    IResource resource = resourceDescription.createResourceHandle();
                    factory.create(resource);
                }
                ++n2;
            }
        } else {
            int i = 0;
            while (i < this.resources.length) {
                update = true;
                IResource resource = this.resources[i];
                factory.copy(resource, this.getDestinationPath(resource, i));
                ++i;
            }
        }
        return update;
    }

    @Override
    public IStatus computeUndoableStatus(IProgressMonitor monitor) {
        IStatus status = super.computeUndoableStatus(monitor);
        if (!status.isOK()) {
            return status;
        }
        if (this.originalResources == null) {
            this.markInvalid();
            return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
        }
        IResourceSnapshot<? extends IResource>[] iResourceSnapshotArray = this.snapshotResourceDescriptions;
        int n = this.snapshotResourceDescriptions.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceSnapshot<? extends IResource> snapshotResourceDescription = iResourceSnapshotArray[n2];
            if (!snapshotResourceDescription.verifyExistence(true)) {
                this.markInvalid();
                return this.getErrorStatus(UndoMessages.CopyResourcesOperation_NotAllowedDueToDataLoss);
            }
            ++n2;
        }
        if (status.isOK()) {
            status = this.computeDeleteStatus();
        }
        if (status.isOK() && this.resourceDescriptions != null && this.resourceDescriptions.length > 0) {
            status = this.computeCreateStatus(true);
        }
        return status;
    }

    private void setOriginalResources(IResource[] originals) {
        this.originalResources = originals;
        this.snapshotResourceDescriptions = new IResourceSnapshot[originals.length];
        int i = 0;
        while (i < originals.length) {
            this.snapshotResourceDescriptions[i] = ResourceSnapshotFactory.fromResource((IResource)originals[i]);
            ++i;
        }
    }
}

