/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import com.ibm.icu.util.ULocale;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;

final class R31Enhance {
    private static final boolean R31_AVAILABLE;
    private static ILogger logger;

    static {
        logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setAdvanced(true);
        R31_AVAILABLE = gc.getAdvanced();
        gc.dispose();
        if (R31_AVAILABLE) {
            logger.log(1, Messages.getString("R31Enhance.info.advanced.enabled", ULocale.getDefault()));
        } else {
            logger.log(1, Messages.getString("R31Enhance.info.advanced.disabled", ULocale.getDefault()));
        }
    }

    private R31Enhance() {
    }

    public static boolean isR31Available() {
        return R31_AVAILABLE;
    }

    static void setAdvanced(GC gc, boolean value, Region clipping) {
        if (R31_AVAILABLE) {
            gc.setAdvanced(value);
            gc.setClipping(clipping);
        }
    }

    static void setAlpha(GC gc, int value) {
        if (R31_AVAILABLE) {
            gc.setAlpha(value);
        }
    }

    static void setAntialias(GC gc, int value) {
        if (R31_AVAILABLE) {
            gc.setAntialias(value);
        }
    }

    static void setTextAntialias(GC gc, int value) {
        if (R31_AVAILABLE) {
            gc.setTextAntialias(value);
        }
    }

    static Object newTransform(Device param) {
        if (R31_AVAILABLE) {
            return new Transform(param);
        }
        return null;
    }

    static void setTransform(GC gc, Object value) {
        if (R31_AVAILABLE) {
            gc.setTransform((Transform)value);
        }
    }

    static void translate(GC gc, Object transform, float v1, float v2) {
        if (R31_AVAILABLE) {
            ((Transform)transform).translate(v1, v2);
        }
    }

    static void rotate(GC gc, Object transform, float value) {
        if (R31_AVAILABLE) {
            ((Transform)transform).rotate(value);
        }
    }

    static void disposeTransform(Object transform) {
        if (R31_AVAILABLE) {
            ((Transform)transform).dispose();
        }
    }

    static void setAlpha(GC gc, ColorDefinition cd) {
        if (R31_AVAILABLE) {
            if (cd != null && cd.isSetTransparency()) {
                R31Enhance.setAlpha(gc, cd.getTransparency());
            } else {
                R31Enhance.setAlpha(gc, 255);
            }
        }
    }

    static void setAlpha(GC gc, Gradient g) {
        if (R31_AVAILABLE) {
            if (g != null && g.isSetTransparency()) {
                R31Enhance.setAlpha(gc, g.getTransparency());
            } else {
                R31Enhance.setAlpha(gc, 255);
            }
        }
    }
}

