/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;

public class PairCollectionExtractor
implements ICollectionExtractor {
    final String field1;
    final String field2;

    public PairCollectionExtractor(String field1, String field2) {
        this.field1 = field1;
        this.field2 = field2;
    }

    @Override
    public boolean hasSize() {
        return true;
    }

    @Override
    public Integer getSize(IObject coll) throws SnapshotException {
        return 2;
    }

    @Override
    public boolean hasCapacity() {
        return true;
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        return 2;
    }

    @Override
    public boolean hasExtractableContents() {
        return true;
    }

    @Override
    public int[] extractEntryIds(IObject coll) throws SnapshotException {
        int id1 = ((IObject)coll.resolveValue(this.field1)).getObjectId();
        int id2 = ((IObject)coll.resolveValue(this.field2)).getObjectId();
        return new int[]{id1, id2};
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }

    @Override
    public IObjectArray extractEntries(IObject coll) throws SnapshotException {
        throw new IllegalArgumentException();
    }

    @Override
    public Integer getNumberOfNotNullElements(IObject coll) throws SnapshotException {
        return (coll.resolveValue(this.field1) != null ? 1 : 0) + (coll.resolveValue(this.field2) != null ? 1 : 0);
    }

    @Override
    public boolean hasFillRatio() {
        return true;
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        return this.getNumberOfNotNullElements(coll).doubleValue() / 2.0;
    }
}

