/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.internal.collectionextract;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.internal.collectionextract.FieldSizedCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.WrapperCollectionExtractor;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IPrimitiveArray;

public class MATArrayBig
extends FieldSizedCollectionExtractor {
    WrapperCollectionExtractor pages;

    public MATArrayBig(String sizeField, String pagesField) {
        super(sizeField);
        this.pages = new WrapperCollectionExtractor(pagesField);
    }

    @Override
    public boolean hasCapacity() {
        return this.pages.hasExtractableContents();
    }

    @Override
    public Integer getCapacity(IObject coll) throws SnapshotException {
        int[] pageArrays = this.pages.extractEntryIds(coll);
        if (pageArrays == null) {
            return null;
        }
        ISnapshot snapshot = coll.getSnapshot();
        int capacity = 0;
        int[] nArray = pageArrays;
        int n = pageArrays.length;
        int n2 = 0;
        while (n2 < n) {
            IObject a1;
            int a = nArray[n2];
            if (snapshot.isArray(a) && (a1 = snapshot.getObject(a)) instanceof IPrimitiveArray) {
                capacity += ((IPrimitiveArray)a1).getLength();
            }
            ++n2;
        }
        return capacity;
    }

    @Override
    public boolean hasFillRatio() {
        return this.hasCapacity();
    }

    @Override
    public Double getFillRatio(IObject coll) throws SnapshotException {
        Integer size = this.getSize(coll);
        Integer cap = this.getCapacity(coll);
        if (size != null && cap != null) {
            double sz = size.doubleValue();
            double cp = cap.doubleValue();
            if (sz == 0.0 && cp == 0.0) {
                return 1.0;
            }
            return sz / cp;
        }
        return null;
    }

    @Override
    public boolean hasExtractableContents() {
        return false;
    }

    @Override
    public boolean hasExtractableArray() {
        return false;
    }
}

