/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collectionextract;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.HashMapIntObject;
import org.eclipse.mat.inspections.collectionextract.AbstractExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedCollection;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.inspections.collectionextract.ICollectionExtractor;
import org.eclipse.mat.inspections.collectionextract.IMapExtractor;
import org.eclipse.mat.internal.collectionextract.ArrayCollectionExtractor;
import org.eclipse.mat.internal.collectionextract.ExtractionUtils;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.extension.CollectionExtractionInfo;
import org.eclipse.mat.snapshot.extension.JdkVersion;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.IObjectArray;
import org.eclipse.mat.snapshot.registry.CollectionExtractorProviderRegistry;

public class CollectionExtractionUtils {
    private static Map<ISnapshot, HashMapIntObject<ICollectionExtractor>> cache = new WeakHashMap<ISnapshot, HashMapIntObject<ICollectionExtractor>>();

    public static ICollectionExtractor findCollectionExtractor(IObject collection) throws SnapshotException {
        if (collection == null) {
            return null;
        }
        if (collection instanceof IObjectArray) {
            return ArrayCollectionExtractor.INSTANCE;
        }
        ISnapshot snapshot = collection.getSnapshot();
        IClass collectionClass = collection.getClazz();
        HashMapIntObject c1 = cache.get(snapshot);
        if (c1 == null) {
            c1 = new HashMapIntObject();
            cache.put(snapshot, (HashMapIntObject<ICollectionExtractor>)c1);
        } else if (c1.containsKey(collectionClass.getObjectId())) {
            return (ICollectionExtractor)c1.get(collectionClass.getObjectId());
        }
        JdkVersion version = ExtractionUtils.resolveVersion(snapshot);
        for (CollectionExtractionInfo info : CollectionExtractorProviderRegistry.instance().getCollectionExtractionInfo()) {
            if (!info.version.contains((Object)version) || !collectionClass.doesExtend(info.className)) continue;
            c1.put(collectionClass.getObjectId(), (Object)info.extractor);
            return info.extractor;
        }
        c1.put(collectionClass.getObjectId(), null);
        return null;
    }

    public static ICollectionExtractor findCollectionExtractor(String className) throws SnapshotException {
        for (CollectionExtractionInfo info : CollectionExtractorProviderRegistry.instance().getCollectionExtractionInfo()) {
            if (!info.className.equals(className)) continue;
            return info.extractor;
        }
        return null;
    }

    public static AbstractExtractedCollection<?, ?> extractCollection(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        if (extractor instanceof IMapExtractor) {
            return new ExtractedMap(collection, (IMapExtractor)extractor);
        }
        return new ExtractedCollection(collection, extractor);
    }

    public static AbstractExtractedCollection<?, ?> extractCollection(IObject collection, String specificClass, ICollectionExtractor preferredExtractor) throws SnapshotException {
        if (specificClass != null && collection.getClazz().doesExtend(specificClass)) {
            return new ExtractedCollection(collection, preferredExtractor);
        }
        return CollectionExtractionUtils.extractCollection(collection);
    }

    public static ExtractedCollection extractList(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        return new ExtractedCollection(collection, extractor);
    }

    public static ExtractedMap extractMap(IObject collection) throws SnapshotException {
        ICollectionExtractor extractor = CollectionExtractionUtils.findCollectionExtractor(collection);
        if (extractor == null) {
            return null;
        }
        if (extractor instanceof IMapExtractor) {
            return new ExtractedMap(collection, (IMapExtractor)extractor);
        }
        return null;
    }

    public static ExtractedMap extractMap(IObject collection, String specificClass, IMapExtractor preferredExtractor) throws SnapshotException {
        if (specificClass != null && collection.getClazz().doesExtend(specificClass)) {
            return new ExtractedMap(collection, preferredExtractor);
        }
        return CollectionExtractionUtils.extractMap(collection);
    }
}

