/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.ui.editor.MultiPaneEditor;
import org.eclipse.mat.ui.editor.MultiPaneEditorSite;
import org.eclipse.mat.ui.editor.PaneConfiguration;
import org.eclipse.mat.ui.util.PaneState;
import org.eclipse.mat.ui.util.PopupMenu;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

public abstract class AbstractEditorPane
implements IEditorPart {
    protected PaneConfiguration configuration;
    protected AbstractEditorPane parentPane;
    protected IEditorInput input;
    protected IEditorSite site;
    protected List<IPropertyListener> listeners = new ArrayList<IPropertyListener>();
    private Menu contextMenu;
    private PaneState paneState;

    void setConfiguration(PaneConfiguration conf) {
        this.configuration = conf;
    }

    PaneConfiguration getConfiguration() {
        return this.configuration;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.site = site;
        this.input = input;
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public IEditorSite getEditorSite() {
        return this.site;
    }

    public void initWithArgument(Object argument) {
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add(listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePropertyChange(int propId) {
        for (IPropertyListener listener : this.listeners) {
            listener.propertyChanged((Object)this, propId);
        }
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void setFocus() {
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public final void doSave(IProgressMonitor monitor) {
    }

    public final void doSaveAs() {
    }

    public final boolean isDirty() {
        return false;
    }

    public final boolean isSaveAsAllowed() {
        return false;
    }

    public final boolean isSaveOnCloseNeeded() {
        return false;
    }

    public void contributeToToolBar(IToolBarManager manager) {
    }

    public String getPaneId() {
        return this.configuration.getId();
    }

    public AbstractEditorPane getParentPane() {
        return this.parentPane;
    }

    public void dispose() {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        Job.getJobManager().cancel((Object)this);
    }

    protected void hookContextMenu(Control control) {
        if (this.contextMenu != null && !this.contextMenu.isDisposed()) {
            this.contextMenu.dispose();
        }
        this.contextMenu = new Menu((Control)control.getShell());
        this.contextMenu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                MenuItem[] items = AbstractEditorPane.this.contextMenu.getItems();
                int ii = 0;
                while (ii < items.length) {
                    items[ii].dispose();
                    ++ii;
                }
                PopupMenu popup = new PopupMenu();
                AbstractEditorPane.this.editorContextMenuAboutToShow(popup);
                popup.addToMenu(AbstractEditorPane.this.getEditorSite().getActionBars().getStatusLineManager(), AbstractEditorPane.this.contextMenu);
            }
        });
        control.setMenu(this.contextMenu);
    }

    protected void editorContextMenuAboutToShow(PopupMenu menu) {
    }

    public PaneState getPaneState() {
        return this.paneState;
    }

    public void setPaneState(PaneState paneState) {
        this.paneState = paneState;
    }

    public MultiPaneEditor getEditor() {
        return ((MultiPaneEditorSite)this.getEditorSite()).getMultiPageEditor();
    }

    public IQueryContext getQueryContext() {
        return this.getEditor().getQueryContext();
    }
}

