/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections;

import com.ibm.icu.text.NumberFormat;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.query.BytesFormat;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.Category;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.query.results.TextResult;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.Histogram;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.model.ObjectComparators;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.SimpleMonitor;

@CommandName(value="top_consumers")
@Icon(value="/META-INF/icons/pie_chart.gif")
@Category(value="__hidden__")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/top_consumers.html")
public class TopConsumersQuery
implements IQuery {
    NumberFormat percentFormatter = NumberFormat.getIntegerInstance();
    NumberFormat numberFormatter = NumberFormat.getNumberInstance();
    BytesFormat bytesFormatter = BytesFormat.getInstance();
    static final String SEPARATOR = "--------------------------------------------------------------------------------";
    @Argument
    public ISnapshot snapshot;
    @Argument(advice=Argument.Advice.HEAP_OBJECT, isMandatory=false, flag="none")
    public int[] objects;
    @Argument(isMandatory=false, flag="t")
    public int thresholdPercent;

    public TopConsumersQuery() {
        this.percentFormatter.setMinimumFractionDigits(2);
        this.percentFormatter.setMaximumFractionDigits(2);
        this.thresholdPercent = 1;
    }

    public IResult execute(IProgressListener listener) throws Exception {
        int i;
        int[] topDominators;
        long totalHeap;
        SimpleMonitor monitor = new SimpleMonitor(Messages.TopConsumers2Query_TopConsumers, listener, new int[]{100, 100, 100});
        IProgressListener listener0 = listener;
        CharArrayWriter outWriter = new CharArrayWriter(1000);
        PrintWriter out = new PrintWriter(outWriter);
        listener = monitor.nextMonitor();
        if (this.objects == null) {
            totalHeap = this.snapshot.getSnapshotInfo().getUsedHeapSize();
            topDominators = this.snapshot.getImmediateDominatedIds(-1);
        } else {
            if (this.objects.length == 0) {
                return new TextResult(Messages.TopConsumers2Query_MsgNoObjects);
            }
            topDominators = this.snapshot.getTopAncestorsInDominatorTree(this.objects, listener);
            totalHeap = 0L;
            int[] nArray = topDominators;
            int n = topDominators.length;
            int n2 = 0;
            while (n2 < n) {
                int topDominator = nArray[n2];
                totalHeap += this.snapshot.getRetainedHeapSize(topDominator);
                ++n2;
            }
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        long threshold = (long)this.thresholdPercent * totalHeap / 100L;
        ArrayInt suspects = new ArrayInt();
        if (this.objects == null || this.objects.length == 0) {
            i = 0;
            while (i < topDominators.length && this.snapshot.getRetainedHeapSize(topDominators[i]) > threshold) {
                suspects.add(topDominators[i]);
                ++i;
            }
        } else {
            i = 0;
            while (i < topDominators.length) {
                if (this.snapshot.getRetainedHeapSize(topDominators[i]) > threshold) {
                    suspects.add(topDominators[i]);
                }
                ++i;
            }
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        listener = monitor.nextMonitor();
        Histogram histogram = this.groupByClasses(topDominators, listener);
        ClassHistogramRecord[] classRecords = histogram.getClassHistogramRecords().toArray(new ClassHistogramRecord[0]);
        Arrays.sort(classRecords, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        int k = 0;
        ArrayList<ClassHistogramRecord> suspectRecords = new ArrayList<ClassHistogramRecord>();
        while (k < classRecords.length && classRecords[k].getRetainedHeapSize() > threshold) {
            suspectRecords.add(classRecords[k]);
            ++k;
        }
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        ClassLoaderHistogramRecord[] classloaderRecords = histogram.getClassLoaderHistogramRecords().toArray(new ClassLoaderHistogramRecord[0]);
        Arrays.sort(classloaderRecords, Histogram.reverseComparator(Histogram.COMPARATOR_FOR_RETAINEDHEAPSIZE));
        k = 0;
        ArrayList<ClassLoaderHistogramRecord> classloaderSuspectRecords = new ArrayList<ClassLoaderHistogramRecord>();
        while (k < classloaderRecords.length && classloaderRecords[k].getRetainedHeapSize() > threshold) {
            classloaderSuspectRecords.add(classloaderRecords[k]);
            ++k;
        }
        listener = monitor.nextMonitor();
        PackageTreeNode root = this.groupByPackage(topDominators, this.snapshot, listener);
        root.retainedSize = totalHeap;
        root.dominators = new ArrayInt(topDominators);
        out.println();
        out.println(String.valueOf(Messages.TopConsumers2Query_BiggestObjects) + ":");
        out.println(SEPARATOR);
        int[] suspectsArr = suspects.toArray();
        IObject[] objectArr = new IObject[suspectsArr.length];
        int j = 0;
        while (j < suspectsArr.length) {
            objectArr[j] = this.snapshot.getObject(suspectsArr[j]);
            ++j;
        }
        Arrays.sort(objectArr, ObjectComparators.getComparatorForRetainedHeapSizeDescending());
        IObject[] iObjectArray = objectArr;
        int n = objectArr.length;
        int n3 = 0;
        while (n3 < n) {
            IObject obj = iObjectArray[n3];
            long retained = this.snapshot.getRetainedHeapSize(obj.getObjectId());
            out.print(this.percentFormatter.format((double)(retained * 100L) / (double)totalHeap));
            out.print("%  ");
            out.print(this.bytesFormatter.format((Object)retained));
            out.print("  ");
            out.print(obj.getTechnicalName());
            String details = obj.getClassSpecificName();
            if (details != null) {
                out.print("  ");
                out.print(details);
            }
            out.println();
            ++n3;
        }
        out.println();
        out.println(String.valueOf(Messages.TopConsumers2Query_BiggestClasses) + ":");
        out.println(SEPARATOR);
        for (ClassHistogramRecord rec : suspectRecords) {
            long retained = rec.getRetainedHeapSize();
            out.print(this.percentFormatter.format((double)(retained * 100L) / (double)totalHeap));
            out.print("%  ");
            out.print(this.bytesFormatter.format((Object)retained));
            out.print("  ");
            out.print(this.numberFormatter.format(rec.getNumberOfObjects()));
            out.print("  ");
            out.print(rec.getLabel());
            out.println();
        }
        out.println();
        out.println(String.valueOf(Messages.TopConsumers2Query_BiggestClassLoaders) + ":");
        out.println(SEPARATOR);
        for (ClassLoaderHistogramRecord rec : classloaderSuspectRecords) {
            long retained = rec.getRetainedHeapSize();
            out.print(this.percentFormatter.format((double)(retained * 100L) / (double)totalHeap));
            out.print("%  ");
            out.print(this.bytesFormatter.format((Object)retained));
            out.print("  ");
            out.print(this.numberFormatter.format(rec.getNumberOfObjects()));
            out.print("  ");
            out.print(rec.getLabel());
            out.println();
        }
        out.println();
        out.println(String.valueOf(Messages.TopConsumers2Query_BiggestPackages) + ":");
        out.println(SEPARATOR);
        out.println(Messages.TopConsumersQuery_ColumnLabels);
        out.println(SEPARATOR);
        this.printPackageTree(root, new StringBuilder(), totalHeap, threshold, out, this.snapshot);
        out.close();
        listener0.done();
        return new TextResult(outWriter.toString());
    }

    private Histogram groupByClasses(int[] dominated, IProgressListener listener) throws SnapshotException {
        Histogram histogram = this.snapshot.getHistogram(dominated, listener);
        if (listener.isCanceled()) {
            throw new IProgressListener.OperationCanceledException();
        }
        Collection<ClassHistogramRecord> records = histogram.getClassHistogramRecords();
        ClassHistogramRecord[] arr = new ClassHistogramRecord[records.size()];
        int i = 0;
        for (ClassHistogramRecord record : records) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            record.setRetainedHeapSize(this.sumRetainedSize(record.getObjectIds(), this.snapshot));
            arr[i++] = record;
        }
        Collection<ClassLoaderHistogramRecord> loaderRecords = histogram.getClassLoaderHistogramRecords();
        ClassLoaderHistogramRecord[] loaderArr = new ClassLoaderHistogramRecord[loaderRecords.size()];
        i = 0;
        for (ClassLoaderHistogramRecord record : loaderRecords) {
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            long retainedSize = 0L;
            for (ClassHistogramRecord classRecord : record.getClassHistogramRecords()) {
                retainedSize += classRecord.getRetainedHeapSize();
            }
            record.setRetainedHeapSize(retainedSize);
            loaderArr[i++] = record;
        }
        return histogram;
    }

    private long sumRetainedSize(int[] objectIds, ISnapshot snapshot) throws SnapshotException {
        long sum = 0L;
        int[] nArray = objectIds;
        int n = objectIds.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            sum += snapshot.getRetainedHeapSize(id);
            ++n2;
        }
        return sum;
    }

    private PackageTreeNode groupByPackage(int[] dominators, ISnapshot snapshot, IProgressListener listener) throws SnapshotException {
        PackageTreeNode root = new PackageTreeNode(Messages.TopConsumers2Query_Label_all);
        listener.beginTask(Messages.TopConsumers2Query_GroupingByPackage, (dominators.length + 999) / 1000);
        int counter = 0;
        int[] nArray = dominators;
        int n = dominators.length;
        int n2 = 0;
        while (n2 < n) {
            IObject dominatorObj;
            int dominatorId = nArray[n2];
            if (listener.isCanceled()) {
                throw new IProgressListener.OperationCanceledException();
            }
            long retainedSize = snapshot.getRetainedHeapSize(dominatorId);
            PackageTreeNode current = root;
            IClass objClass = snapshot.getClassOf(dominatorId);
            if ("java.lang.Class".equals(objClass.getName()) && (dominatorObj = snapshot.getObject(dominatorId)) instanceof IClass) {
                objClass = (IClass)dominatorObj;
            }
            String className = objClass.getName();
            StringTokenizer tokenizer = new StringTokenizer(className, ".");
            while (tokenizer.hasMoreTokens()) {
                String subpack = tokenizer.nextToken();
                PackageTreeNode childNode = current.subpackages.get(subpack);
                if (childNode == null) {
                    childNode = new PackageTreeNode(subpack);
                    current.subpackages.put(subpack, childNode);
                }
                childNode.dominators.add(dominatorId);
                childNode.retainedSize += retainedSize;
                current = childNode;
            }
            if (++counter % 1000 == 0) {
                listener.worked(1);
            }
            ++n2;
        }
        listener.done();
        return root;
    }

    private void printPackageTree(PackageTreeNode node, StringBuilder level, long totalHeap, long threshold, PrintWriter out, ISnapshot snapshot) throws SnapshotException {
        StringBuilder output = new StringBuilder(level.length() + 100);
        output.append((CharSequence)level);
        output.append(node.packageName);
        output.append("  (");
        double percent = (double)(node.retainedSize * 100L) / (double)totalHeap;
        output.append(this.percentFormatter.format(percent));
        output.append("%)  ");
        output.append(this.bytesFormatter.format((Object)node.retainedSize));
        output.append("  ");
        output.append(this.numberFormatter.format((long)node.dominators.size()));
        out.println(output);
        Object[] children = node.subpackages.values().toArray(new PackageTreeNode[0]);
        if (children != null) {
            Arrays.sort(children);
            int i = 0;
            while (i < children.length) {
                if (((PackageTreeNode)children[i]).retainedSize < threshold) break;
                int k = level.indexOf("'-");
                if (k != -1) {
                    level.replace(k, k + 2, "  ");
                } else {
                    k = level.indexOf("|-");
                    if (k != -1) {
                        level.replace(k + 1, k + 2, " ");
                    }
                }
                if (i == children.length - 1 || ((PackageTreeNode)children[i + 1]).retainedSize < threshold) {
                    level.append('\'');
                } else {
                    level.append('|');
                }
                level.append("- ");
                this.printPackageTree((PackageTreeNode)children[i], level, totalHeap, threshold, out, snapshot);
                ++i;
            }
        }
        if (level.length() >= 3) {
            level.delete(level.length() - 3, level.length());
        }
    }

    private static class PackageTreeNode
    implements Comparable<PackageTreeNode> {
        String packageName;
        ArrayInt dominators = new ArrayInt();
        Map<String, PackageTreeNode> subpackages = new HashMap<String, PackageTreeNode>();
        long retainedSize;

        public int hashCode() {
            return Objects.hash(this.packageName, this.retainedSize);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PackageTreeNode other = (PackageTreeNode)obj;
            return Objects.equals(this.packageName, other.packageName) && this.retainedSize == other.retainedSize;
        }

        public PackageTreeNode(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public int compareTo(PackageTreeNode o) {
            if (this.retainedSize < o.retainedSize) {
                return 1;
            }
            if (this.retainedSize > o.retainedSize) {
                return -1;
            }
            return this.packageName.compareTo(o.packageName);
        }
    }
}

