/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.actions;

import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.query.annotations.Icon;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.ui.Messages;
import org.eclipse.mat.ui.util.Copy;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.swt.widgets.Display;

@Icon(value="/icons/copy.gif")
@HelpUrl(value="/org.eclipse.mat.ui.help/reference/inspections/copy.html#ref_inspections_copy__copyoql")
public class CopyOQL
implements IQuery {
    @Argument
    public List<IContextObject> elements;
    @Argument
    public Display display;

    public IResult execute(IProgressListener listener) throws Exception {
        String lineSeparator = System.getProperty("line.separator");
        listener.beginTask(Messages.CopyOQL_Copying, this.elements.size());
        final StringBuilder buf = new StringBuilder(128);
        for (IContextObject element : this.elements) {
            if (element instanceof IContextObjectSet) {
                String buf1 = ((IContextObjectSet)element).getOQL();
                if (buf1 != null) {
                    OQL.union((StringBuilder)buf, (String)buf1);
                } else {
                    int[] ids = ((IContextObjectSet)element).getObjectIds();
                    if (ids.length > 10000) {
                        throw new SnapshotException(Messages.CopyOQL_TooBig);
                    }
                    String oql = OQL.forObjectIds((int[])ids);
                    if (oql != null) {
                        OQL.union((StringBuilder)buf, (String)oql);
                    }
                }
            } else {
                int id = element.getObjectId();
                if (id >= 0) {
                    OQL.union((StringBuilder)buf, (String)OQL.forObjectId((int)id));
                }
            }
            listener.worked(1);
            if (buf.length() > 60000) {
                throw new SnapshotException(Messages.CopyOQL_TooBig);
            }
            if (listener.isCanceled()) break;
        }
        listener.done();
        buf.append(lineSeparator);
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                Copy.copyToClipboard(buf.toString(), CopyOQL.this.display);
            }
        });
        throw new IProgressListener.OperationCanceledException();
    }
}

