/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.Collection;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.project.IMavenProjectFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactHelper {
    private static final String M2_REPO_PREFIX = "var/M2_REPO/";

    public static IPath getLocalRepoRelativePath(Artifact artifact) {
        if (artifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        IPath m2repo = JavaCore.getClasspathVariable((String)"M2_REPO");
        Path absolutePath = new Path(artifact.getFile().getAbsolutePath());
        IPath relativePath = absolutePath.removeFirstSegments(m2repo.segmentCount()).makeRelative().setDevice(null);
        return relativePath;
    }

    public static IProject getWorkspaceProject(Artifact artifact) {
        IMavenProjectFacade facade = ArtifactHelper.getWorkspaceProjectMavenFacade(artifact);
        return facade == null ? null : facade.getProject();
    }

    public static IMavenProjectFacade getWorkspaceProjectMavenFacade(Artifact artifact) {
        IMavenProjectFacade workspaceProject = MavenPlugin.getMavenProjectRegistry().getMavenProject(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        if (workspaceProject != null && workspaceProject.getFullPath(artifact.getFile()) != null) {
            return workspaceProject;
        }
        return null;
    }

    public static String getM2REPOVarPath(Artifact artifact) {
        if (ArtifactHelper.getWorkspaceProject(artifact) != null) {
            return null;
        }
        return M2_REPO_PREFIX + ArtifactHelper.getLocalRepoRelativePath(artifact).toPortableString();
    }

    @Deprecated
    public static void fixArtifactHandler(ArtifactHandler artifactHandler) {
        if ("app-client".equals(artifactHandler.getExtension()) && artifactHandler instanceof DefaultArtifactHandler) {
            ((DefaultArtifactHandler)artifactHandler).setExtension("jar");
            ((DefaultArtifactHandler)artifactHandler).setAddedToClasspath(true);
        }
    }

    public static Artifact getArtifact(Collection<Artifact> artifacts, ArtifactKey key) {
        if (artifacts == null || key == null || artifacts.isEmpty()) {
            return null;
        }
        for (Artifact a : artifacts) {
            ArtifactKey ak = ArtifactHelper.toArtifactKey(a);
            if (!key.equals((Object)ak)) continue;
            return a;
        }
        return null;
    }

    public static ArtifactKey toArtifactKey(Artifact a) {
        return new ArtifactKey(a.getGroupId(), a.getArtifactId(), a.getBaseVersion(), a.getClassifier());
    }
}

