/*
 * Decompiled with CFR 0.152.
 */
package lpg.runtime;

import lpg.runtime.ConfigurationElement;
import lpg.runtime.ObjectTuple;
import lpg.runtime.ParseTable;
import lpg.runtime.StateElement;

public class ConfigurationStack {
    private static final int TABLE_SIZE = 1021;
    private ConfigurationElement[] table = new ConfigurationElement[1021];
    private ObjectTuple configuration_stack = new ObjectTuple(4096);
    private StateElement state_root;
    private int max_configuration_size;
    private int stacks_size;
    private int state_element_size;
    ParseTable prs;

    public ConfigurationStack(ParseTable prs) {
        this.prs = prs;
        ++this.state_element_size;
        this.state_root = new StateElement();
        this.state_root.parent = null;
        this.state_root.siblings = null;
        this.state_root.children = null;
        this.state_root.number = prs.getStartState();
    }

    StateElement makeStateList(StateElement parent, int[] stack, int index, int stack_top) {
        int i = index;
        while (i <= stack_top) {
            ++this.state_element_size;
            StateElement state = new StateElement();
            state.number = stack[i];
            state.parent = parent;
            state.children = null;
            state.siblings = null;
            parent.children = state;
            parent = state;
            ++i;
        }
        return parent;
    }

    StateElement findOrInsertStack(StateElement root, int[] stack, int index, int stack_top) {
        int state_number = stack[index];
        StateElement p = root;
        while (p != null) {
            if (p.number == state_number) {
                return index == stack_top ? p : (p.children == null ? this.makeStateList(p, stack, index + 1, stack_top) : this.findOrInsertStack(p.children, stack, index + 1, stack_top));
            }
            p = p.siblings;
        }
        ++this.state_element_size;
        StateElement node = new StateElement();
        node.number = state_number;
        node.parent = root.parent;
        node.children = null;
        node.siblings = root.siblings;
        root.siblings = node;
        return index == stack_top ? node : this.makeStateList(node, stack, index + 1, stack_top);
    }

    public boolean findConfiguration(int[] stack, int stack_top, int curtok) {
        StateElement last_element = this.findOrInsertStack(this.state_root, stack, 0, stack_top);
        int hash_address = curtok % 1021;
        ConfigurationElement configuration = this.table[hash_address];
        while (configuration != null) {
            if (configuration.curtok == curtok && last_element == configuration.last_element) {
                return true;
            }
            configuration = configuration.next;
        }
        return false;
    }

    public void push(int[] stack, int stack_top, int conflict_index, int curtok, int action_length) {
        ConfigurationElement configuration = new ConfigurationElement();
        int hash_address = curtok % 1021;
        configuration.next = this.table[hash_address];
        this.table[hash_address] = configuration;
        ++this.max_configuration_size;
        configuration.stack_top = stack_top;
        this.stacks_size += stack_top + 1;
        configuration.last_element = this.findOrInsertStack(this.state_root, stack, 0, stack_top);
        configuration.conflict_index = conflict_index;
        configuration.curtok = curtok;
        configuration.action_length = action_length;
        this.configuration_stack.add(configuration);
    }

    public ConfigurationElement pop() {
        ConfigurationElement configuration = null;
        if (this.configuration_stack.size() > 0) {
            int index = this.configuration_stack.size() - 1;
            configuration = (ConfigurationElement)this.configuration_stack.get(index);
            configuration.act = this.prs.baseAction(configuration.conflict_index++);
            if (this.prs.baseAction(configuration.conflict_index) == 0) {
                this.configuration_stack.reset(index);
            }
        }
        return configuration;
    }

    public ConfigurationElement top() {
        ConfigurationElement configuration = null;
        if (this.configuration_stack.size() > 0) {
            int index = this.configuration_stack.size() - 1;
            configuration = (ConfigurationElement)this.configuration_stack.get(index);
            configuration.act = this.prs.baseAction(configuration.conflict_index);
        }
        return configuration;
    }

    public int size() {
        return this.configuration_stack.size();
    }

    public int maxConfigurationSize() {
        return this.max_configuration_size;
    }

    int numStateElements() {
        return this.state_element_size;
    }

    int stacksSize() {
        return this.stacks_size;
    }
}

