/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.layers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.util.EqualityHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class MappingTableEntry {
    private final Layer parentLayer;
    private final Collection<Layer> indirectParentLayers;
    private final DiagramElementMapping mapping;
    private List<MappingTableEntry> mappingImporters;
    private Collection<MappingTableEntry> otherImporters;

    public MappingTableEntry(DiagramElementMapping mapping, Layer parentLayer, Collection<Layer> indirectParentLayers) {
        this.mapping = mapping;
        this.parentLayer = parentLayer;
        this.indirectParentLayers = indirectParentLayers;
        this.mappingImporters = new ArrayList<MappingTableEntry>();
    }

    public MappingTableEntry searchMappingEntry(DiagramElementMapping searchedMapping) {
        if (EqualityHelper.areEquals((EObject)this.mapping, (EObject)searchedMapping)) {
            return this;
        }
        MappingTableEntry result = this.find(this.getImporters(), searchedMapping);
        if (result == null) {
            result = this.searchInOtherImporters(searchedMapping, this);
        }
        return result;
    }

    private MappingTableEntry find(Collection<MappingTableEntry> entries, DiagramElementMapping searchedMapping) {
        MappingTableEntry result = null;
        for (MappingTableEntry entry : entries) {
            if (EqualityHelper.areEquals((EObject)entry.mapping, (EObject)searchedMapping)) {
                result = entry;
                break;
            }
            MappingTableEntry findEntry = this.find(entry.getImporters(), searchedMapping);
            if (findEntry == null) continue;
            result = findEntry;
            break;
        }
        return result;
    }

    private MappingTableEntry searchInOtherImporters(DiagramElementMapping searchedMapping, MappingTableEntry entry) {
        if (EqualityHelper.areEquals((EObject)entry.mapping, (EObject)searchedMapping)) {
            return entry;
        }
        return this.searchInOtherImporters(searchedMapping, entry.getOtherImporters());
    }

    private MappingTableEntry searchInOtherImporters(DiagramElementMapping searchedMapping, Collection<MappingTableEntry> entries) {
        Iterator<MappingTableEntry> iterator = entries.iterator();
        if (iterator.hasNext()) {
            MappingTableEntry entry = iterator.next();
            return this.searchInOtherImporters(searchedMapping, entry);
        }
        return null;
    }

    public Collection<? extends MappingTableEntry> getChildren() {
        return Collections.emptySet();
    }

    public void setImporter(MappingTableEntry mNode) {
        if (this.mappingImporters == null) {
            this.mappingImporters = new ArrayList<MappingTableEntry>();
        }
        if (!this.mappingImporters.isEmpty()) {
            this.mappingImporters.remove(0);
        }
        this.mappingImporters.add(0, mNode);
    }

    public boolean isImported() {
        return this.mappingImporters != null && !this.mappingImporters.isEmpty();
    }

    public DiagramElementMapping getMapping() {
        return this.mapping;
    }

    public Option<MappingTableEntry> getImporter() {
        if (this.mappingImporters == null || this.mappingImporters.isEmpty()) {
            return Options.newNone();
        }
        return Options.newSome((Object)this.mappingImporters.get(0));
    }

    public Collection<MappingTableEntry> getImporters() {
        return this.mappingImporters;
    }

    public void addOtherImporters(MappingTableEntry importer) {
        this.mappingImporters.add(importer);
        if (this.otherImporters == null) {
            this.otherImporters = new ArrayList<MappingTableEntry>();
        }
        this.otherImporters.add(importer);
    }

    public Collection<MappingTableEntry> getOtherImporters() {
        if (this.otherImporters == null) {
            return Collections.emptyList();
        }
        return this.otherImporters;
    }

    public Layer getParentLayer() {
        return this.parentLayer;
    }

    public Collection<Layer> getIndirectParentLayers() {
        return this.indirectParentLayers;
    }
}

