/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui;

import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jdt.internal.debug.ui.DebugUIMessages;
import org.eclipse.jdt.internal.debug.ui.IJDIPreferencesConstants;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.ui.filtertable.FilterManager;
import org.eclipse.jdt.internal.ui.filtertable.JavaFilterTable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class JavaStepFilterPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "org.eclipse.jdt.debug.ui.JavaStepFilterPreferencePage";
    private static final FilterManager STEP_FILTERS = new FilterManager(IJDIPreferencesConstants.PREF_ACTIVE_FILTERS_LIST, IJDIPreferencesConstants.PREF_INACTIVE_FILTERS_LIST);
    private JavaFilterTable fStepFilterTable;
    private Button fUseStepFiltersButton;
    private Button fFilterSyntheticButton;
    private Button fFilterStaticButton;
    private Button fFilterGetterButton;
    private Button fFilterSetterButton;
    private Button fFilterConstructorButton;
    private Button fStepThruButton;

    public JavaStepFilterPreferencePage() {
        this.setPreferenceStore(JDIDebugUIPlugin.getDefault().getPreferenceStore());
        this.setTitle(DebugUIMessages.JavaStepFilterPreferencePage_title);
        this.setDescription(DebugUIMessages.JavaStepFilterPreferencePage_description);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), IJavaDebugHelpContextIds.JAVA_STEP_FILTER_PREFERENCE_PAGE);
        Composite composite = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808, (int)0, (int)0);
        this.createStepFilterPreferences(composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    private void createStepFilterPreferences(Composite parent) {
        Composite container = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)2, (int)1, (int)1808, (int)0, (int)0);
        this.fUseStepFiltersButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage__Use_step_filters, null, (boolean)DebugUITools.isUseStepFilters(), (int)2);
        this.fUseStepFiltersButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                JavaStepFilterPreferencePage.this.setPageEnablement(JavaStepFilterPreferencePage.this.fUseStepFiltersButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.initializeDialogUnits((Control)container);
        this.fStepFilterTable = new JavaFilterTable((PreferencePage)this, STEP_FILTERS, new JavaFilterTable.FilterTableConfig().setAddFilter(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage_Add__Filter_9, DebugUIMessages.JavaStepFilterPreferencePage_Key_in_the_name_of_a_new_step_filter_10)).setAddType(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage_Add__Type____11, DebugUIMessages.JavaStepFilterPreferencePage_Choose_a_Java_type_and_add_it_to_step_filters_12)).setAddPackage(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage_Add__Package____13, DebugUIMessages.JavaStepFilterPreferencePage_Choose_a_package_and_add_it_to_step_filters_14)).setRemove(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage__Remove_15, DebugUIMessages.JavaStepFilterPreferencePage_Remove_all_selected_step_filters_16)).setSelectAll(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage__Select_All_1, DebugUIMessages.JavaStepFilterPreferencePage_Selects_all_step_filters_2)).setDeselectAll(new JavaFilterTable.ButtonLabel(DebugUIMessages.JavaStepFilterPreferencePage_Deselect_All_3, DebugUIMessages.JavaStepFilterPreferencePage_Deselects_all_step_filters_4)).setAddTypeDialog(new JavaFilterTable.DialogLabels(DebugUIMessages.JavaStepFilterPreferencePage_Add_type_to_step_filters_20, DebugUIMessages.JavaStepFilterPreferencePage_Select_a_type_to_filter_when_stepping_23)).setErrorAddTypeDialog(new JavaFilterTable.DialogLabels(DebugUIMessages.JavaStepFilterPreferencePage_Add_type_to_step_filters_20, DebugUIMessages.JavaStepFilterPreferencePage_Could_not_open_type_selection_dialog_for_step_filters_21)).setAddPackageDialog(new JavaFilterTable.DialogLabels(DebugUIMessages.JavaStepFilterPreferencePage_Add_package_to_step_filters_24, DebugUIMessages.JavaStepFilterPreferencePage_Select_a_package_to_filter_when_stepping_27)).setLabelText(DebugUIMessages.JavaStepFilterPreferencePage_Defined_step_fi_lters__8).setHelpContextId(IJavaDebugHelpContextIds.JAVA_STEP_FILTER_PREFERENCE_PAGE));
        this.fStepFilterTable.createTable(container);
        this.createStepFilterCheckboxes(container);
        this.setPageEnablement(this.fUseStepFiltersButton.getSelection());
    }

    protected void setPageEnablement(boolean enabled) {
        this.fFilterConstructorButton.setEnabled(enabled);
        this.fStepThruButton.setEnabled(enabled);
        this.fFilterGetterButton.setEnabled(enabled);
        this.fFilterSetterButton.setEnabled(enabled);
        this.fFilterStaticButton.setEnabled(enabled);
        this.fFilterSyntheticButton.setEnabled(enabled);
        this.fStepFilterTable.setEnabled(enabled);
    }

    private void createStepFilterCheckboxes(Composite container) {
        this.fFilterSyntheticButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_Filter_s_ynthetic_methods__requires_VM_support__17, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS), (int)2);
        this.fFilterStaticButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_Filter_static__initializers_18, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS), (int)2);
        this.fFilterConstructorButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_Filter_co_nstructors_19, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS), (int)2);
        this.fFilterGetterButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_Filter_getters, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_GETTERS), (int)2);
        this.fFilterSetterButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_Filter_setters, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_FILTER_SETTERS), (int)2);
        this.fStepThruButton = SWTFactory.createCheckButton((Composite)container, (String)DebugUIMessages.JavaStepFilterPreferencePage_0, null, (boolean)this.getPreferenceStore().getBoolean(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS), (int)2);
    }

    public boolean performOk() {
        DebugUITools.setUseStepFilters((boolean)this.fUseStepFiltersButton.getSelection());
        IPreferenceStore store = this.getPreferenceStore();
        this.fStepFilterTable.performOk(store);
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS, this.fFilterConstructorButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS, this.fFilterStaticButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_GETTERS, this.fFilterGetterButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_SETTERS, this.fFilterSetterButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS, this.fFilterSyntheticButton.getSelection());
        store.setValue(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS, this.fStepThruButton.getSelection());
        return super.performOk();
    }

    protected void performDefaults() {
        this.fUseStepFiltersButton.setSelection(false);
        this.setPageEnablement(false);
        this.fFilterSyntheticButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_SYNTHETICS));
        this.fFilterStaticButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_STATIC_INITIALIZERS));
        this.fFilterConstructorButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_CONSTRUCTORS));
        this.fFilterGetterButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_GETTERS));
        this.fFilterSetterButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_FILTER_SETTERS));
        this.fStepThruButton.setSelection(this.getPreferenceStore().getDefaultBoolean(IJDIPreferencesConstants.PREF_STEP_THRU_FILTERS));
        this.fStepFilterTable.performDefaults();
        super.performDefaults();
    }
}

