/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lyo.tools.codegenerator.ui.common;

import adaptorinterface.AdaptorInterface;
import adaptorinterface.Specification;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.acceleo.engine.service.AbstractAcceleoGenerator;
import org.eclipse.acceleo.engine.utils.AcceleoLaunchingUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.lyo.oslc4j.codegenerator.main.Generate;
import org.eclipse.lyo.oslc4j.codegenerator.main.GenerateSpecification;
import org.eclipse.lyo.tools.codegenerator.ui.Activator;
import org.eclipse.lyo.tools.codegenerator.ui.popupMenus.DialogServices;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class GenerateAll {
    private File targetFolder;
    private AbstractAcceleoGenerator generator;

    public GenerateAll(URI modelURI, File targetFolder, List<? extends Object> arguments) throws IOException {
        this.generator = new Generate(modelURI, targetFolder, arguments);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.lyo.oslc4j.codegenerator", (String)"org.eclipse.lyo.oslc4j.codegenerator.main.Generate", (String)modelURI.toString(), (String)targetFolder.toString(), new ArrayList());
        this.generator.setGenerationID(generationID);
        this.targetFolder = targetFolder;
    }

    public GenerateAll(AdaptorInterface adaptorInterface, File targetFolder, List<? extends Object> arguments) throws IOException {
        this.generator = new Generate((EObject)adaptorInterface, targetFolder, arguments);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.lyo.oslc4j.codegenerator", (String)"org.eclipse.lyo.oslc4j.codegenerator.main.Generate", (String)adaptorInterface.toString(), (String)targetFolder.toString(), new ArrayList());
        this.generator.setGenerationID(generationID);
        this.targetFolder = targetFolder;
    }

    public GenerateAll(Specification specification, File targetFolder, List<? extends Object> arguments) throws IOException {
        this.generator = new GenerateSpecification((EObject)specification, targetFolder, arguments);
        String generationID = AcceleoLaunchingUtil.computeUIProjectID((String)"org.eclipse.lyo.oslc4j.codegenerator", (String)"org.eclipse.lyo.oslc4j.codegenerator.main.GenerateSpecification", (String)specification.toString(), (String)targetFolder.toString(), new ArrayList());
        this.generator.setGenerationID(generationID);
        this.targetFolder = targetFolder;
    }

    public void doGenerate() throws IOException {
        if (!this.targetFolder.exists()) {
            this.targetFolder.mkdirs();
        }
        IRunnableWithProgress operation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                try {
                    monitor.subTask("Loading...");
                    monitor.worked(1);
                    GenerateAll.this.generator.doGenerate(BasicMonitor.toMonitor((IProgressMonitor)monitor));
                    DialogServices.showMessage("Generation Success", "Generation completed on \"" + GenerateAll.this.targetFolder.toString() + "\".");
                }
                catch (IOException e) {
                    Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
                    Activator.getDefault().getLog().log((IStatus)status);
                    DialogServices.showMessage("Exception!", "an Exception occurred during the generation process. Please see the error log.");
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, operation);
        }
        catch (InterruptedException | InvocationTargetException e) {
            Status status = new Status(4, "org.eclipse.lyo.tools.codegenerator.ui", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            DialogServices.showMessage("Exception!", "an Exception occurred during the generation process. Please see the error log.");
        }
    }

    private URI getTemplateURI(String bundleID, IPath relativePath) throws IOException {
        Enumeration entries;
        Bundle bundle = Platform.getBundle((String)bundleID);
        if (bundle == null) {
            return URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        }
        URL url = bundle.getEntry(relativePath.toString());
        if (url == null && relativePath.segmentCount() > 1 && (entries = bundle.findEntries("/", "*.emtl", true)) != null) {
            String[] segmentsRelativePath = relativePath.segments();
            while (url == null && entries.hasMoreElements()) {
                String[] segmentsPath;
                URL entry = (URL)entries.nextElement();
                Path path = new Path(entry.getPath());
                if (path.segmentCount() > relativePath.segmentCount()) {
                    path = path.removeFirstSegments(path.segmentCount() - relativePath.segmentCount());
                }
                boolean equals = (segmentsPath = path.segments()).length == segmentsRelativePath.length;
                int i = 0;
                while (equals && i < segmentsPath.length) {
                    equals = segmentsPath[i].equals(segmentsRelativePath[i]);
                    ++i;
                }
                if (!equals) continue;
                url = bundle.getEntry(entry.getPath());
            }
        }
        URI result = url != null ? URI.createPlatformPluginURI((String)new Path(bundleID).append((IPath)new Path(url.getPath())).toString(), (boolean)false) : URI.createPlatformResourceURI((String)new Path(bundleID).append(relativePath).toString(), (boolean)false);
        return result;
    }
}

