/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.wizards.pages;

import java.text.MessageFormat;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.ui.tools.api.color.VisualBindingManager;
import org.eclipse.sirius.ui.tools.internal.viewpoint.ViewpointHelper;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationDescriptionItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.RepresentationItemImpl;
import org.eclipse.sirius.ui.tools.internal.views.common.item.ViewpointItemImpl;
import org.eclipse.sirius.ui.tools.internal.wizards.pages.SiriusRepresentationLabelProvider;
import org.eclipse.sirius.viewpoint.provider.Messages;
import org.eclipse.swt.graphics.Color;

public class SiriusRepresentationWithInactiveStatusLabelProvider
extends SiriusRepresentationLabelProvider {
    @Override
    public Color getForeground(Object element) {
        Color result = null;
        if (element instanceof ViewpointItemImpl) {
            ViewpointItemImpl viewpointItem = (ViewpointItemImpl)element;
            if (!ViewpointHelper.isViewpointEnabledInSession((Session)viewpointItem.getSession().get(), viewpointItem.getViewpoint())) {
                result = VisualBindingManager.getDefault().getColorFromName("gray");
            }
        } else if (element instanceof RepresentationDescriptionItemImpl) {
            result = this.getForeground(((RepresentationDescriptionItemImpl)element).getParent());
        } else if (element instanceof RepresentationItemImpl) {
            result = this.getForeground(((RepresentationItemImpl)element).getParent());
        }
        if (result == null) {
            result = super.getForeground(element);
        }
        return result;
    }

    @Override
    public String getText(Object element) {
        ViewpointItemImpl viewpointItem;
        String text = super.getText(element);
        if (element instanceof ViewpointItemImpl && !ViewpointHelper.isViewpointEnabledInSession((Session)(viewpointItem = (ViewpointItemImpl)element).getSession().get(), viewpointItem.getViewpoint())) {
            text = String.valueOf(text) + " (" + Messages.GraphicalRepresentationHandler_disabledViewpoint_label + ")";
        }
        if (element instanceof RepresentationDescriptionItemImpl) {
            RepresentationDescriptionItemImpl descriptionItem = (RepresentationDescriptionItemImpl)element;
            text = String.valueOf(text) + MessageFormat.format(Messages.GraphicalRepresentationHandler_representationNumber_label, descriptionItem.getChildren().size());
        }
        return text;
    }

    public String getToolTipText(Object element) {
        String result = null;
        if (element instanceof ViewpointItemImpl) {
            result = Messages.SiriusRepresentationWithInactiveStatusLabelProvider_viewpointItem_tooltip;
        } else if (element instanceof RepresentationDescriptionItemImpl) {
            result = Messages.SiriusRepresentationWithInactiveStatusLabelProvider_representationDescriptionItem_tooltip;
        }
        return result;
    }
}

