/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse;

import org.apache.jena.atlas.io.IndentedLineBuffer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.sse.ItemException;
import org.apache.jena.sparql.sse.ItemList;
import org.apache.jena.sparql.sse.ItemLocation;
import org.apache.jena.sparql.sse.ItemVisitor;
import org.apache.jena.sparql.sse.ItemWriter;
import org.apache.jena.sparql.util.FmtUtils;

public class Item
extends ItemLocation {
    protected ItemList list = null;
    protected Node node = null;
    protected String symbol = null;
    protected boolean isNil = false;
    public static final Item nil = Item.createNil();
    public static final Item defaultItem = Item.createSymbol("_");

    public static Item createList() {
        return Item.createList(-1, -1);
    }

    public static Item createList(int line, int column) {
        Item item = new Item(line, column);
        item.list = new ItemList(line, column);
        return item;
    }

    public static Item createList(ItemList list) {
        return Item.createList(list, -1, -1);
    }

    public static Item createList(ItemList list, int line, int column) {
        Item item = new Item(line, column);
        item.list = list;
        return item;
    }

    public static Item createNode(Node node) {
        return Item.createNode(node, -1, -1);
    }

    public static Item createNode(Node node, int line, int column) {
        Item item = new Item(line, column);
        item.node = node;
        return item;
    }

    public static Item createSymbol(String symbol) {
        return Item.createSymbol(symbol, -1, -1);
    }

    public static Item createSymbol(String symbol, int line, int column) {
        if (symbol.equals("nil")) {
            return Item.createNil(line, column);
        }
        Item item = new Item(line, column);
        item.symbol = symbol;
        return item;
    }

    private static Item createNil() {
        return Item.createNil(-1, -1);
    }

    private static Item createNil(int line, int column) {
        Item item = new Item(-1, -1);
        item.isNil = true;
        return item;
    }

    public static Item createTagged(String tag) {
        Item tagged = Item.createList();
        tagged.getList().add(Item.createSymbol(tag));
        return tagged;
    }

    public static void addPair(ItemList list, String key, String value) {
        Item.addPair(list, Item.createSymbol(key), Item.createNode(NodeFactory.createLiteral((String)value)));
    }

    public static void addPair(ItemList list, String key, Node node) {
        Item.addPair(list, Item.createSymbol(key), Item.createNode(node));
    }

    public static void addPair(ItemList list, Node key, Node value) {
        Item.addPair(list, Item.createNode(key), Item.createNode(value));
    }

    public static void addPair(ItemList list, Item key, Item value) {
        Item pair = Item.makePair(key, value);
        list.add(pair);
    }

    public static Item makePair(Item item1, Item item2) {
        Item list = Item.createList();
        list.getList().add(item1);
        list.getList().add(item2);
        return list;
    }

    public static Item find(ItemList list, String key) {
        for (Item x : list) {
            if (!x.isTagged(key)) continue;
            return x;
        }
        return null;
    }

    private Item(int line, int column) {
        super(line, column);
    }

    private Item() {
        super(-1, -1);
    }

    public int hashCode() {
        ItemHashCode itemHashCode = new ItemHashCode();
        this.visit(itemHashCode);
        return itemHashCode.hashCode;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Item)) {
            return false;
        }
        ItemEquals x = new ItemEquals((Item)other);
        this.visit(x);
        return x.result;
    }

    public boolean sameSymbol(Item item) {
        if (item.isSymbol()) {
            return this.sameSymbol(item.getSymbol());
        }
        return false;
    }

    public boolean sameSymbol(String symbolStr) {
        return this.isSymbol() && this.getSymbol().equalsIgnoreCase(symbolStr);
    }

    public ItemList getList() {
        return this.list;
    }

    public Node getNode() {
        return this.node;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public double getDouble() {
        if (!this.isNode()) {
            throw new ItemException("Not a node, can't be a double: " + this);
        }
        if (!this.getNode().isLiteral()) {
            throw new ItemException("Not a literal, can't be a double: " + this);
        }
        return ((Number)this.getNode().getLiteralValue()).doubleValue();
    }

    public long getInteger() {
        if (!this.isNode()) {
            throw new ItemException("Not a node, can't be an integer: " + this);
        }
        if (!this.getNode().isLiteral()) {
            throw new ItemException("Not a literal, can't be a integer: " + this);
        }
        return ((Number)this.getNode().getLiteralValue()).longValue();
    }

    public int getInt() {
        if (!this.isNode()) {
            throw new ItemException("Not a node, can't be an integer: " + this);
        }
        if (!this.getNode().isLiteral()) {
            throw new ItemException("Not a literal, can't be a integer: " + this);
        }
        return ((Number)this.getNode().getLiteralValue()).intValue();
    }

    public long getLong() {
        if (!this.isNode()) {
            throw new ItemException("Not a node, can't be an integer: " + this);
        }
        if (!this.getNode().isLiteral()) {
            throw new ItemException("Not a literal, can't be a integer: " + this);
        }
        return ((Number)this.getNode().getLiteralValue()).longValue();
    }

    @Deprecated
    public long asInteger() {
        return this.asLong();
    }

    public long asLong() {
        if (this.isNode() && this.getNode().isLiteral()) {
            return Long.parseLong(this.getNode().getLiteralLexicalForm());
        }
        if (this.isSymbol()) {
            return Integer.parseInt(this.getSymbol());
        }
        throw new ItemException("Not a literal or string: " + this);
    }

    public String sniff() {
        if (!this.isTaggable()) {
            return null;
        }
        return this.getList().get(0).getSymbol();
    }

    public boolean isTaggedIgnoreCase(String tag) {
        if (!this.isTaggable()) {
            return false;
        }
        return this.getList().isTaggedIgnoreCase(tag);
    }

    public boolean isTagged(String tag) {
        if (!this.isTaggable()) {
            return false;
        }
        return this.getList().isTagged(tag);
    }

    public boolean isTagged() {
        if (!this.isTaggable()) {
            return false;
        }
        return this.list.get(0).isSymbol();
    }

    private boolean isTaggable() {
        if (!this.isList()) {
            return false;
        }
        return !this.list.isEmpty();
    }

    public boolean isDefault() {
        return defaultItem.equals(this);
    }

    public boolean isNil() {
        return this.isNil;
    }

    public boolean isList() {
        return this.list != null;
    }

    public boolean isNode() {
        return this.getNode() != null;
    }

    public boolean isNodeURI() {
        return this.isNode() && this.getNode().isURI();
    }

    public boolean isVar() {
        return Var.isVar(this.getNode());
    }

    public boolean isNodeLiteral() {
        return this.isNode() && this.getNode().isLiteral();
    }

    public boolean isNodeBNode() {
        return this.isNode() && this.getNode().isBlank();
    }

    public boolean isSymbol() {
        return this.symbol != null;
    }

    public boolean isSymbol(String testSymbol) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equals(testSymbol);
    }

    public boolean isSymbolIgnoreCase(String testSymbol) {
        if (this.symbol == null) {
            return false;
        }
        return this.symbol.equalsIgnoreCase(testSymbol);
    }

    public void visit(ItemVisitor visitor) {
        if (this.isList()) {
            visitor.visit(this, this.getList());
        } else if (this.isNode()) {
            visitor.visit(this, this.getNode());
        } else if (this.isSymbol()) {
            visitor.visit(this, this.getSymbol());
        } else if (this.isNil()) {
            visitor.visitNil(this);
        } else {
            Log.error(Item.class, (String)"broken item");
        }
    }

    @Override
    public String toString() {
        IndentedLineBuffer iBuff = new IndentedLineBuffer();
        ItemWriter.write((IndentedWriter)iBuff, this, null);
        return iBuff.asString();
    }

    public String shortString() {
        if (this.isSymbol()) {
            return this.getSymbol();
        }
        if (this.isNode()) {
            return FmtUtils.stringForNode(this.getNode());
        }
        return this.getList().shortString();
    }

    static class ItemEquals
    implements ItemVisitor {
        private Item other;
        boolean result = false;

        ItemEquals(Item other) {
            this.other = other;
        }

        @Override
        public void visit(Item item, ItemList list) {
            this.result = this.other.isList() && this.other.getList().equals(list);
        }

        @Override
        public void visit(Item item, Node node) {
            this.result = this.other.isNode() && this.other.getNode().equals((Object)node);
        }

        @Override
        public void visit(Item item, String symbol) {
            this.result = this.other.isSymbol() && this.other.getSymbol().equals(symbol);
        }

        @Override
        public void visitNil(Item item) {
            this.result = this.other.isNil();
        }
    }

    static class ItemHashCode
    implements ItemVisitor {
        int hashCode = 0;

        ItemHashCode() {
        }

        @Override
        public void visit(Item item, ItemList list) {
            this.hashCode = list.hashCode();
        }

        @Override
        public void visit(Item item, Node node) {
            this.hashCode = node.hashCode();
        }

        @Override
        public void visit(Item item, String symbol) {
            this.hashCode = symbol.hashCode();
        }

        @Override
        public void visitNil(Item item) {
            this.hashCode = -99;
        }
    }
}

