/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec.http;

import java.net.http.HttpClient;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.http.HttpEnv;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.HttpRDF;
import org.apache.jena.http.Push;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.sparql.ARQException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.http.DSP;
import org.apache.jena.sparql.exec.http.StoreProtocol;
import org.apache.jena.sparql.graph.GraphFactory;

public class GSP
extends StoreProtocol<GSP> {
    private boolean defaultGraph = false;
    private String graphName = null;
    private boolean datasetGraph = false;

    public static GSP service(String service) {
        return (GSP)new GSP().endpoint(service);
    }

    public static GSP request() {
        return new GSP();
    }

    protected GSP() {
    }

    @Override
    protected GSP thisBuilder() {
        return this;
    }

    public GSP graphName(String graphName) {
        Objects.requireNonNull(graphName);
        this.graphName = graphName;
        this.defaultGraph = false;
        return this;
    }

    public GSP graphName(Node graphName) {
        Objects.requireNonNull(graphName);
        this.clearOperation();
        if (!graphName.isURI() && !graphName.isBlank()) {
            throw GSP.exception("Not an acceptable graph name: " + this.graphName);
        }
        Node gn = RiotLib.blankNodeToIri(graphName);
        this.graphName = gn.getURI();
        this.defaultGraph = false;
        return this;
    }

    public GSP defaultGraph() {
        this.clearOperation();
        this.defaultGraph = true;
        return this;
    }

    @Deprecated
    public GSP dataset() {
        this.clearOperation();
        return this;
    }

    private void clearOperation() {
        this.defaultGraph = false;
        this.graphName = null;
    }

    protected final void validateGraphOperation() {
        Objects.requireNonNull(this.serviceEndpoint);
        if (!this.defaultGraph && this.graphName == null) {
            throw GSP.exception("Need either default graph or a graph name");
        }
    }

    public Graph GET() {
        this.validateGraphOperation();
        this.ensureAcceptHeader("text/turtle,application/n-triples;q=0.9,application/ld+json;q=0.8,application/rdf+xml;q=0.7,*/*;q=0.3");
        String url = this.graphRequestURL();
        Graph graph = GraphFactory.createDefaultGraph();
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        HttpRDF.httpGetToStream(hc, url, this.httpHeaders, StreamRDFLib.graph(graph));
        return graph;
    }

    public void POST(String file) {
        this.validateGraphOperation();
        String url = this.graphRequestURL();
        String fileExtContentType = this.contentTypeFromFilename(file);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        GSP.uploadTriples(hc, url, file, fileExtContentType, this.httpHeaders, Push.POST);
    }

    public void POST(Graph graph) {
        this.validateGraphOperation();
        RDFFormat requestFmt = this.rdfFormat(HttpEnv.defaultTriplesFormat);
        String url = this.graphRequestURL();
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        HttpRDF.httpPostGraph(hc, url, graph, requestFmt, this.httpHeaders);
    }

    public void PUT(String file) {
        this.validateGraphOperation();
        String url = this.graphRequestURL();
        String fileExtContentType = this.contentTypeFromFilename(file);
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        GSP.uploadTriples(hc, url, file, fileExtContentType, this.httpHeaders, Push.PUT);
    }

    public void PUT(Graph graph) {
        this.validateGraphOperation();
        RDFFormat requestFmt = this.rdfFormat(HttpEnv.defaultTriplesFormat);
        String url = this.graphRequestURL();
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        HttpRDF.httpPutGraph(hc, url, graph, requestFmt, this.httpHeaders);
    }

    public void DELETE() {
        this.validateGraphOperation();
        String url = this.graphRequestURL();
        HttpClient hc = this.requestHttpClient(this.serviceEndpoint, url);
        HttpRDF.httpDeleteGraph(hc, url);
    }

    protected static String queryStringForGraph(String graphName) {
        if (graphName == null) {
            return "default";
        }
        switch (graphName) {
            case "default": {
                return "default";
            }
            case "union": {
                return "graph=union";
            }
        }
        return "graph=" + HttpLib.urlEncodeQueryString(graphName);
    }

    protected final String graphName() {
        return this.graphName;
    }

    protected final boolean isDefaultGraph() {
        return this.graphName == null;
    }

    protected final boolean isGraphOperation() {
        return this.defaultGraph || this.graphName != null;
    }

    private String graphRequestURL() {
        return HttpLib.requestURL(this.serviceEndpoint, GSP.queryStringForGraph(this.graphName));
    }

    protected final void internalDataset() {
        this.datasetGraph = true;
    }

    protected final void validateDatasetOperation() {
        Objects.requireNonNull(this.serviceEndpoint);
        if (this.defaultGraph) {
            throw GSP.exception("Default graph specified for dataset operation");
        }
        if (this.graphName != null) {
            throw GSP.exception("A graph name specified for dataset operation");
        }
        if (!this.datasetGraph) {
            throw GSP.exception("Dataset request not specified for dataset operation");
        }
    }

    @Deprecated
    public DatasetGraph getDataset() {
        this.internalDataset();
        this.validateDatasetOperation();
        return this.newDSP().GET();
    }

    @Deprecated
    public void postDataset(String file) {
        this.internalDataset();
        this.validateDatasetOperation();
        this.newDSP().POST(file);
    }

    @Deprecated
    public void postDataset(DatasetGraph dataset) {
        this.internalDataset();
        this.validateDatasetOperation();
        this.newDSP().POST(dataset);
    }

    @Deprecated
    public void putDataset(String file) {
        this.internalDataset();
        this.validateDatasetOperation();
        this.newDSP().PUT(file);
    }

    @Deprecated
    public void putDataset(DatasetGraph dataset) {
        this.internalDataset();
        this.validateDatasetOperation();
        this.newDSP().PUT(dataset);
    }

    @Deprecated
    public void clearDataset() {
        this.internalDataset();
        this.validateDatasetOperation();
        this.newDSP().clear();
    }

    private DSP newDSP() {
        DSP dsp = new DSP();
        dsp.copySetup(this);
        return dsp;
    }

    private static void uploadTriples(HttpClient httpClient, String gspUrl, String file, String fileExtContentType, Map<String, String> headers, Push mode) {
        Lang lang = RDFLanguages.contentTypeToLang(fileExtContentType);
        if (lang == null) {
            throw new ARQException("Not a recognized as an RDF format: " + fileExtContentType);
        }
        if (RDFLanguages.isQuads(lang) && !RDFLanguages.isTriples(lang)) {
            throw new ARQException("Can't load quads into a graph");
        }
        if (!RDFLanguages.isTriples(lang)) {
            throw new ARQException("Not an RDF format: " + file + " (lang=" + lang + ")");
        }
        GSP.pushFile(httpClient, gspUrl, file, fileExtContentType, headers, mode);
    }
}

