/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.api.CompactionApi;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.document.RdfDocument;
import com.apicatalog.jsonld.processor.FromRdfProcessor;
import com.apicatalog.rdf.RdfDataset;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.JsonWriterFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFFormatVariant;
import org.apache.jena.riot.WriterDatasetRIOT;
import org.apache.jena.riot.system.JenaTitanium;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.JenaException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.util.Context;

public class JsonLD11Writer
implements WriterDatasetRIOT {
    private static Map<String, ?> configIndented = Map.of("jakarta.json.stream.JsonGenerator.prettyPrinting", true);
    private static Map<String, ?> configFlat = Map.of();
    private final RDFFormat format;

    public JsonLD11Writer(RDFFormat format) {
        this.format = format;
    }

    private Map<String, ?> config(boolean indented) {
        return indented ? configIndented : configFlat;
    }

    @Override
    public void write(OutputStream outputStream, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(outputStream);
        Objects.requireNonNull(datasetGraph);
        this.write$(outputStream, null, datasetGraph);
    }

    @Override
    public void write(Writer out, DatasetGraph datasetGraph, PrefixMap prefixMap, String baseURI, Context context2) {
        Objects.requireNonNull(out);
        Objects.requireNonNull(datasetGraph);
        this.write$(null, out, datasetGraph);
    }

    @Override
    public Lang getLang() {
        return this.format.getLang();
    }

    private void write$(OutputStream output, Writer writer, DatasetGraph dsg) {
        try {
            JsonStructure writeThis;
            RdfDataset ds = JenaTitanium.convert(dsg);
            Document doc = RdfDocument.of((RdfDataset)ds);
            RDFFormatVariant variant = this.format.getVariant();
            boolean indented = true;
            if (Lib.equals((Object)variant, (Object)RDFFormat.PRETTY)) {
                writeThis = this.writePretty(doc, dsg);
            } else if (variant == null || Lib.equals((Object)variant, (Object)RDFFormat.PLAIN)) {
                writeThis = this.writePlain(doc, dsg);
            } else if (Lib.equals((Object)variant, (Object)RDFFormat.FLAT)) {
                writeThis = this.writePlain(doc, dsg);
                indented = false;
            } else {
                writeThis = this.writePretty(doc, dsg);
            }
            if (writeThis == null) {
                FmtLog.error(this.getClass(), (String)"Nothing to write", (Object[])new Object[0]);
                return;
            }
            if (!(writeThis instanceof JsonObject)) {
                FmtLog.warn(this.getClass(), (String)"Output is not a JSON object (%s)", (Object[])new Object[]{writeThis.getClass().getSimpleName()});
            }
            JsonWriter jsonWriter = this.startWrite(output, writer, indented);
            jsonWriter.write(writeThis);
            this.finishWrite(output, writer, indented);
        }
        catch (Throwable ex) {
            throw new JenaException("Exception while writing JSON-LD 1.1", ex);
        }
    }

    private JsonStructure writePlain(Document doc, DatasetGraph dsg) throws JsonLdError {
        JsonArray array = JsonLd.fromRdf((Document)doc).get();
        JsonObject writeRdf = Json.createObjectBuilder().add("@graph", (JsonValue)array).build();
        return writeRdf;
    }

    private JsonStructure writePretty(Document doc, DatasetGraph dsg) throws JsonLdError {
        JsonLdOptions options = new JsonLdOptions();
        JsonArray array = FromRdfProcessor.fromRdf((Document)doc, (JsonLdOptions)options);
        JsonObjectBuilder cxt = Json.createObjectBuilder().add("@version", "1.1");
        dsg.prefixes().forEach((k, v) -> {
            if (!k.isEmpty()) {
                cxt.add(k, v);
            }
        });
        String vocab = dsg.prefixes().get("");
        if (vocab != null) {
            cxt.add("@vocab", vocab);
        }
        JsonObject context2 = cxt.build();
        JsonObject writeRdf = Json.createObjectBuilder().add("@context", (JsonValue)context2).add("@graph", (JsonValue)array).build();
        JsonDocument contextDoc = JsonDocument.of((JsonStructure)context2);
        CompactionApi api = JsonLd.compact((Document)JsonDocument.of((JsonStructure)writeRdf), (Document)contextDoc);
        api.rdfStar();
        JsonObject x = api.get();
        return x;
    }

    private JsonWriter startWrite(OutputStream output, Writer writer, boolean indented) {
        Map<String, ?> config = this.config(indented);
        JsonWriterFactory factory = Json.createWriterFactory(config);
        return output != null ? factory.createWriter(output) : factory.createWriter(writer);
    }

    private void finishWrite(OutputStream output, Writer writer, boolean indented) throws IOException {
        boolean outputNL = indented;
        if (output != null) {
            if (outputNL) {
                output.write(10);
            }
            output.flush();
        } else {
            if (outputNL) {
                writer.write("\n");
            }
            writer.flush();
        }
    }
}

