/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store.xloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.jena.atlas.AtlasException;
import org.apache.jena.atlas.lib.Bytes;
import org.apache.jena.atlas.lib.Hex;
import org.apache.jena.tdb.base.record.Record;
import org.apache.jena.tdb.base.record.RecordFactory;
import org.apache.jena.tdb.lib.ColumnMap;

public final class RecordsFromInput
implements Iterator<Record> {
    private final InputStream input;
    private Record slot = null;
    private boolean finished = false;
    private final byte[] buffer;
    private int len = -1;
    private int idx;
    private final int rowLength;
    private final int rowBlockSize;
    private final RecordFactory recordFactory;
    private final int itemsPerRow;
    private final ColumnMap colMap;

    public RecordsFromInput(InputStream input, int itemsPerRow, ColumnMap colMap, int rowBlockSize) {
        this.input = input;
        this.itemsPerRow = itemsPerRow;
        this.colMap = colMap;
        this.rowLength = itemsPerRow * 16 + itemsPerRow;
        this.rowBlockSize = rowBlockSize;
        this.buffer = new byte[this.rowLength * rowBlockSize];
        this.idx = -1;
        this.recordFactory = new RecordFactory(itemsPerRow * 8, 0);
    }

    @Override
    public boolean hasNext() {
        if (this.finished) {
            return false;
        }
        if (this.slot != null) {
            return true;
        }
        if (this.idx == -1 || this.idx == this.buffer.length) {
            this.len = this.fill();
            if (this.len == -1) {
                this.finished = true;
                return false;
            }
            this.idx = 0;
        }
        Record record = this.recordFactory.create();
        for (int i = 0; i < this.itemsPerRow; ++i) {
            long x = Hex.getLong((byte[])this.buffer, (int)this.idx);
            this.idx += 16;
            ++this.idx;
            int j = this.colMap == null ? i : this.colMap.mapSlotIdx(i);
            int recordOffset = j * 8;
            Bytes.setLong((long)x, (byte[])record.getKey(), (int)recordOffset);
        }
        if (this.idx >= this.len) {
            this.idx = -1;
        }
        this.slot = record;
        return true;
    }

    private static void printRecord(PrintStream out, Record r, int keyUnitLen) {
        int keySubLen = r.getKey().length / keyUnitLen;
        for (int i = 0; i < keyUnitLen; ++i) {
            int k;
            if (i != 0) {
                out.print(" ");
            }
            for (int j = k = i * keySubLen; j < k + keySubLen; ++j) {
                out.printf("%02x", r.getKey()[j]);
            }
        }
        out.println();
    }

    private int fill() {
        try {
            int len;
            int count;
            for (len = 0; len < this.buffer.length && (count = this.input.read(this.buffer, len, this.buffer.length - len)) != -1; len += count) {
            }
            if (len == 0) {
                return -1;
            }
            if (len % this.rowLength != 0) {
                throw new AtlasException("Wrong length: " + len);
            }
            return len;
        }
        catch (IOException ex) {
            throw new AtlasException((Throwable)ex);
        }
    }

    @Override
    public Record next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Record r = this.slot;
        this.slot = null;
        return r;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

