/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfpatch.changes;

import org.apache.jena.ext.com.google.common.base.Objects;
import org.apache.jena.graph.Node;
import org.apache.jena.rdfpatch.changes.RDFChangesCounter;
import org.apache.jena.rdfpatch.system.Printer;

public class RDFChangesLogSummary
extends RDFChangesCounter {
    private final Printer printer;
    private Node node = null;
    private static int AbbrevUuidLen = "uuid:".length() + 6;

    public RDFChangesLogSummary(Printer printer) {
        this.printer = printer;
    }

    @Override
    public void header(String field, Node value) {
        if (Objects.equal((Object)field, (Object)"id")) {
            this.node = value;
        }
        super.header(field, value);
    }

    @Override
    public void finish() {
        if (this.summary.getDepth() != 0L) {
            return;
        }
        String s = "unset";
        if (this.node != null) {
            s = this.node.isURI() ? this.node.getURI() : (this.node.isBlank() ? this.node.getBlankNodeLabel() : this.node.getLiteralLexicalForm());
        }
        if (s.startsWith("uuid:") && s.length() > AbbrevUuidLen) {
            s = s.substring(0, 11);
        }
        this.printer.print("%s :: Add %d :: Del %d :: P-Add %d :: P-Del %d", s, this.summary.countAddData, this.summary.countDeleteData, this.summary.countAddPrefix, this.summary.countDeletePrefix);
        super.reset();
    }
}

