/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb.store;

import java.util.Map;
import java.util.Objects;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.riot.system.PrefixLib;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapBase;
import org.apache.jena.tdb.store.DatasetPrefixStorage;

public class GraphPrefixesProjection
extends PrefixMapBase {
    private final String graphName;
    private final DatasetPrefixStorage prefixes;

    public GraphPrefixesProjection(String graphName, DatasetPrefixStorage prefixes) {
        Objects.requireNonNull(graphName);
        Objects.requireNonNull(prefixes);
        this.graphName = graphName;
        this.prefixes = prefixes;
    }

    public String get(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        return this.prefixes.readPrefix(this.graphName, prefix);
    }

    public Map<String, String> getMapping() {
        return this.prefixes.readPrefixMap(this.graphName);
    }

    public void add(String prefix, String iriString) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(iriString);
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        this.prefixes.insertPrefix(this.graphName, prefix, iriString);
    }

    public void delete(String prefix) {
        Objects.requireNonNull(prefix);
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        this.prefixes.removeFromPrefixMap(this.graphName, prefix);
    }

    public void clear() {
        this.prefixes.removeAllFromPrefixMap(this.graphName);
    }

    public boolean containsPrefix(String prefix) {
        return this.get(prefix) != null;
    }

    public String abbreviate(String uriStr) {
        Objects.requireNonNull(uriStr);
        return PrefixLib.abbreviate((PrefixMap)this, (String)uriStr);
    }

    public Pair<String, String> abbrev(String uriStr) {
        Objects.requireNonNull(uriStr);
        return PrefixLib.abbrev((PrefixMap)this, (String)uriStr);
    }

    public String expand(String prefix, String localName) {
        Objects.requireNonNull(prefix);
        Objects.requireNonNull(localName);
        prefix = PrefixLib.canonicalPrefix((String)prefix);
        return PrefixLib.expand((PrefixMap)this, (String)prefix, (String)localName);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.getMapping().size();
    }
}

