/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shex.Shex;
import org.apache.jena.shex.ShexShape;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.sys.SysShex;

public class ShexSchema {
    private final ShexShape startShape;
    private final List<ShexShape> shapes;
    private final Map<Node, ShexShape> shapeMap;
    private final Map<Node, TripleExpression> tripleRefs;
    private ShexSchema shapesWithImports = null;
    private final String sourceURI;
    private final String baseURI;
    private final PrefixMap prefixes;
    private final List<String> imports;

    public static ShexSchema shapes(String source, String baseURI, PrefixMap prefixes, ShexShape startShape, List<ShexShape> shapes, List<String> imports, Map<Node, TripleExpression> tripleRefs) {
        shapes = new ArrayList<ShexShape>(shapes);
        LinkedHashMap<Node, ShexShape> shapeMap = new LinkedHashMap<Node, ShexShape>();
        for (ShexShape shape : shapes) {
            if (shape.getLabel() == null) {
                System.err.println("No shape label");
                continue;
            }
            shapeMap.put(shape.getLabel(), shape);
        }
        tripleRefs = new LinkedHashMap<Node, TripleExpression>(tripleRefs);
        return new ShexSchema(source, baseURI, prefixes, startShape, shapes, shapeMap, imports, tripleRefs);
    }

    ShexSchema(String source, String baseURI, PrefixMap prefixes, ShexShape startShape, List<ShexShape> shapes, Map<Node, ShexShape> shapeMap, List<String> imports, Map<Node, TripleExpression> tripleRefMap) {
        this.sourceURI = source;
        this.baseURI = baseURI;
        this.prefixes = prefixes;
        this.startShape = startShape;
        this.shapes = shapes;
        this.shapeMap = shapeMap;
        this.imports = imports;
        this.tripleRefs = tripleRefMap;
    }

    public ShexShape getStart() {
        return this.startShape;
    }

    public List<ShexShape> getShapes() {
        return this.shapes;
    }

    public TripleExpression getTripleExpression(Node label) {
        return this.tripleRefs.get(label);
    }

    public boolean hasImports() {
        return this.imports != null && !this.imports.isEmpty();
    }

    public List<String> getImports() {
        return this.imports;
    }

    public String getSource() {
        return this.sourceURI;
    }

    public String getBase() {
        return this.baseURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShexSchema importsClosure() {
        if (this.shapesWithImports != null) {
            return this.shapesWithImports;
        }
        if (this.imports == null || this.imports.isEmpty()) {
            return this;
        }
        ShexSchema shexSchema = this;
        synchronized (shexSchema) {
            if (this.shapesWithImports != null) {
                return this.shapesWithImports;
            }
            HashSet<String> importsVisited = new HashSet<String>();
            if (this.sourceURI != null) {
                importsVisited.add(this.sourceURI);
            }
            ArrayList<ShexSchema> others = new ArrayList<ShexSchema>();
            others.add(this);
            ShexSchema.closure(this.imports, importsVisited, others);
            ArrayList<ShexShape> mergedShapes = new ArrayList<ShexShape>();
            LinkedHashMap<Node, ShexShape> mergedShapeMap = new LinkedHashMap<Node, ShexShape>();
            LinkedHashMap<Node, TripleExpression> mergedTripleRefs = new LinkedHashMap<Node, TripleExpression>();
            ShexSchema.mergeOne(this, mergedShapes, mergedShapeMap, mergedTripleRefs);
            for (ShexSchema importedSchema : others) {
                ShexSchema.mergeOne(importedSchema, mergedShapes, mergedShapeMap, mergedTripleRefs);
            }
            this.shapesWithImports = new ShexSchema(this.sourceURI, this.baseURI, this.prefixes, this.startShape, mergedShapes, mergedShapeMap, null, mergedTripleRefs);
            return this.shapesWithImports;
        }
    }

    private static void mergeOne(ShexSchema schema, List<ShexShape> mergedShapes, Map<Node, ShexShape> mergedShapeMap, Map<Node, TripleExpression> mergedTripleRefs) {
        schema.getShapes().stream().filter(sh -> !SysShex.startNode.equals((Object)sh.getLabel())).forEach(shape -> {
            mergedShapes.add((ShexShape)shape);
            mergedShapeMap.put(shape.getLabel(), (ShexShape)shape);
        });
        mergedTripleRefs.putAll(schema.tripleRefs);
    }

    private static void closure(List<String> imports, Set<String> importsVisited, List<ShexSchema> visited) {
        if (imports == null || imports.isEmpty()) {
            return;
        }
        for (String imp : imports) {
            if (importsVisited.contains(imp)) continue;
            importsVisited.add(imp);
            ShexSchema others = Shex.readSchema(imp);
            visited.add(others);
            ShexSchema.closure(others.imports, importsVisited, visited);
        }
    }

    public ShexShape get(Node n) {
        if (SysShex.startNode.equals((Object)n)) {
            return this.startShape;
        }
        return this.shapeMap.get(n);
    }

    public boolean hasShape(Node n) {
        return this.shapeMap.containsKey(n);
    }

    public PrefixMap getPrefixMap() {
        return this.prefixes;
    }

    public boolean sameAs(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShexSchema other = (ShexSchema)obj;
        return Objects.equals(this.imports, other.imports) && Objects.equals(this.shapeMap, other.shapeMap) && Objects.equals(this.startShape, other.startShape);
    }
}

