/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.dboe.storage.prefixes;

import org.apache.jena.dboe.storage.StoragePrefixes;
import org.apache.jena.dboe.storage.prefixes.PrefixMapBase;
import org.apache.jena.dboe.storage.prefixes.PrefixMapI;
import org.apache.jena.dboe.storage.prefixes.PrefixMapStorageSimple;
import org.apache.jena.dboe.storage.prefixes.PrefixMappingOverPrefixMapI;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixMap;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesEmpty;
import org.apache.jena.dboe.storage.prefixes.StoragePrefixesView;
import org.apache.jena.dboe.storage.simple.StoragePrefixesMem;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.PrefixMapping;

public class PrefixesFactory {
    private static StoragePrefixes emptyDatasetPrefixes = new StoragePrefixesEmpty();
    private static PrefixMapI emptyPrefixMap = PrefixesFactory.newPrefixMap(PrefixesFactory.storagePrefixMapDft(emptyDatasetPrefixes));

    public static PrefixMapI createMem() {
        return PrefixesFactory.newPrefixMap(PrefixesFactory.newPrefixMapStorageMem());
    }

    public static StoragePrefixes newDatasetPrefixesMem() {
        return new StoragePrefixesMem();
    }

    public static PrefixMapping newPrefixMappingOverPrefixMapI(PrefixMapI pmap) {
        return new PrefixMappingOverPrefixMapI(pmap);
    }

    public static StoragePrefixMap storagePrefixMapDft(StoragePrefixes storage) {
        return StoragePrefixesView.viewDefaultGraph(storage);
    }

    public static StoragePrefixMap storagePrefixMapGraph(StoragePrefixes storage, Node graphName) {
        return StoragePrefixesView.viewGraph(storage, graphName);
    }

    public static StoragePrefixMap newPrefixMapStorageMem() {
        return new PrefixMapStorageSimple();
    }

    public static PrefixMapI newPrefixMap(StoragePrefixMap storage) {
        return new PrefixMapBase(storage);
    }

    public static PrefixMapI empty() {
        return emptyPrefixMap;
    }
}

