/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.system;

import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public class TxnCounter
implements Transactional {
    private Semaphore writersWaiting = new Semaphore(1, true);
    private final AtomicLong value = new AtomicLong(-1712L);
    private final AtomicLong epoch = new AtomicLong(1L);
    private ThreadLocal<IntegerState> transactionValue = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<ReadWrite> transactionMode = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<TxnType> transactionType = ThreadLocal.withInitial(() -> null);
    private ThreadLocal<Long> transactionEpoch = ThreadLocal.withInitial(() -> null);
    private Object txnLifecycleLock = new Object();

    private void releaseWriterLock() {
        int x = this.writersWaiting.availablePermits();
        if (x != 0) {
            throw new JenaTransactionException("TransactionCoordinator: Probably mismatch of enable/disableWriter calls");
        }
        this.writersWaiting.release();
    }

    private boolean acquireWriterLock(boolean canBlock) {
        if (!canBlock) {
            return this.writersWaiting.tryAcquire();
        }
        try {
            this.writersWaiting.acquire();
            return true;
        }
        catch (InterruptedException e2) {
            throw new JenaTransactionException(e2);
        }
    }

    public TxnCounter(long x) {
        this.value.set(x);
    }

    @Override
    public void begin(ReadWrite readWrite) {
        this.begin(TxnType.convert(readWrite));
    }

    @Override
    public void begin(TxnType txnType) {
        this.begin(txnType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void begin(TxnType txnType, boolean canBlock) {
        if (txnType == TxnType.WRITE) {
            this.acquireWriterLock(canBlock);
        }
        Object object = this.txnLifecycleLock;
        synchronized (object) {
            if (this.transactionMode.get() != null) {
                throw new JenaTransactionException("Already in a transaction");
            }
            this.transactionEpoch.set(this.epoch.get());
            IntegerState state = new IntegerState(this.value.get());
            this.transactionValue.set(state);
            this.transactionMode.set(TxnType.initial(txnType));
            this.transactionType.set(txnType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean promote(Transactional.Promote promoteMode) {
        this.checkTxn();
        if (this.transactionMode.get() == ReadWrite.WRITE) {
            return true;
        }
        if (this.transactionType.get() == TxnType.READ) {
            throw new JenaTransactionException("Attempt to promote a READ transsction");
        }
        if (promoteMode == Transactional.Promote.READ_COMMITTED) {
            this.acquireWriterLock(true);
            this.transactionMode.set(ReadWrite.WRITE);
            IntegerState state = new IntegerState(this.value.get());
            this.transactionValue.set(state);
            return true;
        }
        this.acquireWriterLock(true);
        Object object = this.txnLifecycleLock;
        synchronized (object) {
            long nowEpoch = this.epoch.get();
            if (this.transactionEpoch.get() != nowEpoch) {
                this.releaseWriterLock();
                return false;
            }
            this.transactionMode.set(ReadWrite.WRITE);
        }
        return true;
    }

    @Override
    public void commit() {
        this.checkTxn();
        if (this.isWriteTxn()) {
            long thisEpoch = this.epoch.incrementAndGet();
            this.value.set(this.getDataState().txnValue);
            this.transactionValue.set(null);
            this.releaseWriterLock();
        }
        this.endOnce();
    }

    @Override
    public void abort() {
        this.checkTxn();
        if (this.isWriteTxn()) {
            this.transactionValue.set(null);
            this.releaseWriterLock();
        }
        this.endOnce();
    }

    @Override
    public boolean isInTransaction() {
        return Lib.readThreadLocal(this.transactionMode) != null;
    }

    @Override
    public ReadWrite transactionMode() {
        return (ReadWrite)((Object)Lib.readThreadLocal(this.transactionMode));
    }

    @Override
    public TxnType transactionType() {
        return (TxnType)((Object)Lib.readThreadLocal(this.transactionType));
    }

    @Override
    public void end() {
        if (!this.isInTransaction()) {
            return;
        }
        if (this.isWriteTxn() && this.transactionValue.get() != null) {
            throw new JenaTransactionException("No commit or abort before end for a write transaction");
        }
        this.endOnce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endOnce() {
        if (this.isActiveTxn()) {
            Object object = this.txnLifecycleLock;
            synchronized (object) {
                this.transactionValue.remove();
                this.transactionType.remove();
                this.transactionMode.remove();
                this.transactionEpoch.remove();
            }
        }
    }

    public void inc() {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        ++ts.txnValue;
    }

    public void dec() {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        --ts.txnValue;
    }

    public long set(long x) {
        this.checkWriteTxn();
        IntegerState ts = this.getDataState();
        long v = ts.txnValue;
        ts.txnValue = x;
        return v;
    }

    public long read() {
        this.checkTxn();
        return this.getDataState().txnValue;
    }

    public long get() {
        if (this.isActiveTxn()) {
            return this.getDataState().txnValue;
        }
        return this.value.get();
    }

    public long value() {
        return this.value.get();
    }

    private boolean isWriteTxn() {
        ReadWrite rw = this.transactionMode.get();
        if (rw == null) {
            throw new JenaTransactionException(Lib.classShortName(this.getClass()) + ".isWriteTxn called outside a transaction");
        }
        return this.transactionMode.get() == ReadWrite.WRITE;
    }

    private boolean isActiveTxn() {
        ReadWrite rw = this.transactionMode.get();
        return rw != null;
    }

    private IntegerState getDataState() {
        return this.transactionValue.get();
    }

    private void checkWriteTxn() {
        if (!this.isWriteTxn()) {
            throw new JenaTransactionException("Not in a write transaction");
        }
    }

    private void checkTxn() {
        if (!this.isActiveTxn()) {
            throw new JenaTransactionException("Not in a transaction");
        }
    }

    static class IntegerState {
        long txnValue;

        public IntegerState(long v) {
            this.txnValue = v;
        }
    }
}

