/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.join;

import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.sparql.algebra.Algebra;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIter2;

public class QueryIterNestedLoopJoin
extends QueryIter2 {
    private long s_countLHS = 0L;
    private long s_countRHS = 0L;
    private long s_countResults = 0L;
    private final List<Binding> leftRows;
    private Iterator<Binding> left = null;
    private QueryIterator right;
    private Binding rowRight = null;
    private Binding slot = null;
    private boolean finished = false;

    public QueryIterNestedLoopJoin(QueryIterator left, QueryIterator right, ExecutionContext cxt) {
        super(left, right, cxt);
        this.leftRows = Iter.toList((Iterator)left);
        this.s_countLHS = this.leftRows.size();
        this.right = right;
    }

    @Override
    protected boolean hasNextBinding() {
        if (this.finished) {
            return false;
        }
        if (this.slot == null) {
            this.slot = this.moveToNextBindingOrNull();
            if (this.slot == null) {
                this.close();
                return false;
            }
        }
        return true;
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding r = this.slot;
        this.slot = null;
        return r;
    }

    protected Binding moveToNextBindingOrNull() {
        if (this.isFinished()) {
            return null;
        }
        while (true) {
            if (this.rowRight == null) {
                if (this.right.hasNext()) {
                    this.rowRight = (Binding)this.right.next();
                    ++this.s_countRHS;
                    this.left = this.leftRows.iterator();
                } else {
                    return null;
                }
            }
            while (this.left.hasNext()) {
                Binding rowLeft = this.left.next();
                Binding r = Algebra.merge(rowLeft, this.rowRight);
                if (r == null) continue;
                ++this.s_countResults;
                return r;
            }
            this.rowRight = null;
        }
    }

    @Override
    protected void requestSubCancel() {
    }

    @Override
    protected void closeSubIterator() {
    }
}

