/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.exec;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.lib.RDFTerm2Json;

public class JsonResults {
    public static JsonArray results(QueryIterator queryIterator, Map<String, Node> template) {
        Iterator<JsonObject> iter = JsonResults.iterator(queryIterator, template);
        JsonArray array = new JsonArray();
        iter.forEachRemaining(x -> array.add((JsonValue)x));
        return array;
    }

    public static Iterator<JsonObject> iterator(QueryIterator queryIterator, Map<String, Node> template) {
        return new JsonResultsIterator(queryIterator, template);
    }

    private static JsonObject generateJsonObject(Binding binding, Map<String, Node> template) {
        JsonObject jsonObject = new JsonObject();
        template.forEach((field, node) -> {
            Node n = Var.isVar(node) ? binding.get(Var.alloc(node)) : node;
            if (n != null) {
                JsonValue value = RDFTerm2Json.fromNode(n);
                jsonObject.put((String)field, value);
            }
        });
        return jsonObject;
    }

    private static class JsonResultsIterator
    implements Iterator<JsonObject> {
        private final QueryIterator queryIterator;
        private final Map<String, Node> template;

        public JsonResultsIterator(QueryIterator queryIterator, Map<String, Node> template) {
            this.queryIterator = queryIterator;
            this.template = template;
        }

        @Override
        public boolean hasNext() {
            if (this.queryIterator == null) {
                return false;
            }
            boolean r = this.queryIterator.hasNext();
            if (!r) {
                this.close();
            }
            return r;
        }

        @Override
        public JsonObject next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(this.getClass() + ".next");
            }
            Binding binding = (Binding)this.queryIterator.next();
            JsonObject jsonObject = JsonResults.generateJsonObject(binding, this.template);
            return jsonObject;
        }

        @Override
        public void forEachRemaining(Consumer<? super JsonObject> action) {
            if (this.queryIterator == null) {
                return;
            }
            this.queryIterator.forEachRemaining(binding -> action.accept(JsonResults.generateJsonObject(binding, this.template)));
            this.close();
        }

        private void close() {
            this.queryIterator.close();
        }
    }
}

