/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.health.java;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.utils.AnnotationUtils;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.core.utils.JDTTypeUtils;
import org.eclipse.lsp4mp.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4mp.jdt.internal.health.java.MicroProfileHealthErrorCode;

public class MicroProfileHealthDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public boolean isAdaptedForDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = context.getJavaProject();
        return JDTTypeUtils.findType(javaProject, "org.eclipse.microprofile.health.HealthCheck") != null;
    }

    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        ITypeRoot typeRoot = context.getTypeRoot();
        IJavaElement[] elements = typeRoot.getChildren();
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        MicroProfileHealthDiagnosticsParticipant.collectDiagnostics(elements, diagnostics, context, monitor);
        return diagnostics;
    }

    private static void collectDiagnostics(IJavaElement[] elements, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IType type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                return;
            }
            if (element.getElementType() == 7 && !(type = (IType)element).isInterface()) {
                MicroProfileHealthDiagnosticsParticipant.validateClassType(type, diagnostics, context, monitor);
            }
            ++n2;
        }
    }

    private static void validateClassType(IType classType, List<Diagnostic> diagnostics, JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        Diagnostic d;
        Range healthCheckInterfaceRange;
        boolean hasOneOfHealthAnnotation;
        String uri = context.getUri();
        IJDTUtils utils = context.getUtils();
        DocumentFormat documentFormat = context.getDocumentFormat();
        IType[] interfaces = MicroProfileHealthDiagnosticsParticipant.findImplementedInterfaces(classType, monitor);
        boolean implementsHealthCheck = Stream.of(interfaces).anyMatch(interfaceType -> "HealthCheck".equals(interfaceType.getElementName()));
        boolean bl = hasOneOfHealthAnnotation = AnnotationUtils.hasAnnotation((IAnnotatable)classType, "org.eclipse.microprofile.health.Liveness") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "org.eclipse.microprofile.health.Readiness") || AnnotationUtils.hasAnnotation((IAnnotatable)classType, "org.eclipse.microprofile.health.Health");
        if (hasOneOfHealthAnnotation && !implementsHealthCheck) {
            healthCheckInterfaceRange = PositionUtils.toNameRange(classType, utils);
            d = context.createDiagnostic(uri, MicroProfileHealthDiagnosticsParticipant.createDiagnostic1Message(classType, documentFormat), healthCheckInterfaceRange, "microprofile-health", MicroProfileHealthErrorCode.ImplementHealthCheck);
            diagnostics.add(d);
        }
        if (implementsHealthCheck && !hasOneOfHealthAnnotation) {
            healthCheckInterfaceRange = PositionUtils.toNameRange(classType, utils);
            d = context.createDiagnostic(uri, MicroProfileHealthDiagnosticsParticipant.createDiagnostic2Message(classType, documentFormat), healthCheckInterfaceRange, "microprofile-health", MicroProfileHealthErrorCode.HealthAnnotationMissing);
            diagnostics.add(d);
        }
    }

    private static String createDiagnostic1Message(IType classType, DocumentFormat documentFormat) {
        boolean hasHealth;
        StringBuilder message = new StringBuilder("The class ");
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(classType.getFullyQualifiedName());
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(" using the @Liveness");
        boolean bl = hasHealth = JDTTypeUtils.findType(classType.getJavaProject(), "org.eclipse.microprofile.health.Health") != null;
        if (!hasHealth) {
            message.append(" or ");
        } else {
            message.append(", ");
        }
        message.append("@Readiness");
        if (hasHealth) {
            message.append(", or @Health");
        }
        message.append(" annotation should implement the HealthCheck interface.");
        return message.toString();
    }

    private static String createDiagnostic2Message(IType classType, DocumentFormat documentFormat) {
        boolean hasHealth;
        StringBuilder message = new StringBuilder("The class ");
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(classType.getFullyQualifiedName());
        if (DocumentFormat.Markdown.equals((Object)documentFormat)) {
            message.append("`");
        }
        message.append(" implementing the HealthCheck interface should use the @Liveness");
        boolean bl = hasHealth = JDTTypeUtils.findType(classType.getJavaProject(), "org.eclipse.microprofile.health.Health") != null;
        if (!hasHealth) {
            message.append(" or ");
        } else {
            message.append(", ");
        }
        message.append("@Readiness");
        if (hasHealth) {
            message.append(", or @Health");
        }
        message.append(" annotation.");
        return message.toString();
    }

    private static IType[] findImplementedInterfaces(IType type, IProgressMonitor progressMonitor) throws CoreException {
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(progressMonitor);
        return typeHierarchy.getRootInterfaces();
    }
}

