/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Paths;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.lsp4mp.commons.ClasspathKind;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.MicroProfileProjectInfo;
import org.eclipse.lsp4mp.commons.MicroProfilePropertiesScope;
import org.eclipse.lsp4mp.jdt.core.JavaUtils;
import org.eclipse.lsp4mp.jdt.core.PropertiesManager;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.JobHelpers;
import org.eclipse.lsp4mp.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.junit.AfterClass;
import org.junit.BeforeClass;

public class BasePropertiesManagerTest {
    private static final Logger LOGGER = Logger.getLogger(BasePropertiesManagerTest.class.getSimpleName());
    private static Level oldLevel;
    protected static IJDTUtils JDT_UTILS;

    static {
        JDT_UTILS = JDTUtilsLSImpl.getInstance();
    }

    @BeforeClass
    public static void setUp() {
        oldLevel = LOGGER.getLevel();
        LOGGER.setLevel(Level.INFO);
    }

    @AfterClass
    public static void tearDown() {
        LOGGER.setLevel(oldLevel);
    }

    protected static void setJDTUtils(IJDTUtils newUtils) {
        JDT_UTILS = newUtils;
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(String mavenProject) throws CoreException, Exception, JavaModelException {
        return BasePropertiesManagerTest.getMicroProfileProjectInfoFromMavenProject(mavenProject, MicroProfilePropertiesScope.SOURCES_AND_DEPENDENCIES);
    }

    protected static MicroProfileProjectInfo getMicroProfileProjectInfoFromMavenProject(String mavenProject, List<MicroProfilePropertiesScope> scopes) throws CoreException, Exception, JavaModelException {
        IJavaProject javaProject = BasePropertiesManagerTest.loadMavenProject(mavenProject);
        return PropertiesManager.getInstance().getMicroProfileProjectInfo(javaProject, scopes, ClasspathKind.SRC, JDT_UTILS, DocumentFormat.Markdown, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IJavaProject loadMavenProject(String mavenProject) throws CoreException, Exception {
        return BasePropertiesManagerTest.loadJavaProject(mavenProject, "maven");
    }

    public static IJavaProject loadGradleProject(String gradleProject) throws CoreException, Exception {
        return BasePropertiesManagerTest.loadJavaProject(gradleProject, "gradle");
    }

    public static IJavaProject loadMavenProjectFromSubFolder(String mavenProject, String subFolder) throws Exception {
        return BasePropertiesManagerTest.loadJavaProject(mavenProject, Paths.get("maven", subFolder).toString());
    }

    private static IJavaProject loadJavaProject(String projectName, String parentDirName) throws CoreException, Exception {
        File projectFolder = BasePropertiesManagerTest.copyProjectToWorkingDirectory(projectName, parentDirName);
        Path path = new Path(new File(projectFolder, "/.project").getAbsolutePath());
        IProjectDescription description = ResourcesPlugin.getWorkspace().loadProjectDescription((IPath)path);
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(description.getName());
        if (!project.exists()) {
            project.create(description, null);
            project.open(null);
            IWorkspaceRunnable runnable = monitor -> monitor.done();
            NullProgressMonitor monitor2 = new NullProgressMonitor();
            JavaCore.run((IWorkspaceRunnable)runnable, null, (IProgressMonitor)monitor2);
            BasePropertiesManagerTest.waitForBackgroundJobs((IProgressMonitor)monitor2);
        }
        return JavaModelManager.getJavaModelManager().getJavaModel().getJavaProject(description.getName());
    }

    private static File copyProjectToWorkingDirectory(String projectName, String parentDirName) throws IOException {
        File from = new File("projects/" + parentDirName + "/" + projectName);
        File to = new File(JavaUtils.getWorkingProjectDirectory(), Paths.get(parentDirName, projectName).toString());
        if (to.exists()) {
            FileUtils.forceDelete((File)to);
        }
        if (from.isDirectory()) {
            FileUtils.copyDirectory((File)from, (File)to);
        } else {
            FileUtils.copyFile((File)from, (File)to);
        }
        return to;
    }

    private static void waitForBackgroundJobs(IProgressMonitor monitor) throws Exception {
        JobHelpers.waitForJobsToComplete(monitor);
    }

    private static void createFile(IFile file, String contents) throws CoreException {
        BasePropertiesManagerTest.createParentFolders((IResource)file);
        file.refreshLocal(0, null);
        ByteArrayInputStream fileContents = new ByteArrayInputStream(contents.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)fileContents, 0, null);
        } else {
            file.create((InputStream)fileContents, true, null);
        }
    }

    private static void createParentFolders(IResource resource) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            BasePropertiesManagerTest.createParentFolders((IResource)resource.getParent());
        }
        switch (resource.getType()) {
            case 2: {
                ((IFolder)resource).create(1, true, (IProgressMonitor)new NullProgressMonitor());
                break;
            }
            case 4: {
                ((IProject)resource).create((IProgressMonitor)new NullProgressMonitor());
                ((IProject)resource).open((IProgressMonitor)new NullProgressMonitor());
            }
        }
    }

    private static void updateFile(IFile file, String content) throws CoreException {
        try {
            Thread.sleep(1050L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        BasePropertiesManagerTest.createFile(file, content);
    }

    protected static void saveFile(String configFileName, String content, IJavaProject javaProject) throws CoreException {
        BasePropertiesManagerTest.saveFile(configFileName, content, javaProject, false);
    }

    protected static void saveFile(String configFileName, String content, IJavaProject javaProject, boolean inSource) throws CoreException {
        IFile file = BasePropertiesManagerTest.getFile(configFileName, javaProject, inSource);
        BasePropertiesManagerTest.updateFile(file, content);
    }

    protected static void deleteFile(String configFileName, IJavaProject javaProject) throws IOException, CoreException {
        BasePropertiesManagerTest.deleteFile(configFileName, javaProject, false);
    }

    protected static void deleteFile(String configFileName, IJavaProject javaProject, boolean inSource) throws IOException, CoreException {
        IFile file = BasePropertiesManagerTest.getFile(configFileName, javaProject, inSource);
        file.delete(true, (IProgressMonitor)new NullProgressMonitor());
    }

    private static IFile getFile(String configFileName, IJavaProject javaProject, boolean inSource) throws JavaModelException {
        if (inSource) {
            return javaProject.getProject().getFile((IPath)new Path("src/main/java/" + configFileName));
        }
        IPath output = javaProject.getOutputLocation();
        IPath filePath = output.append(configFileName);
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    public static class GradleProjectName {
        public static String empty_gradle_project = "empty-gradle-project";
        public static String quarkus_gradle_project = "quarkus-gradle-project";
        public static String renamed_quarkus_gradle_project = "renamed-gradle";
    }

    public static class MicroProfileMavenProjectName {
        public static String all_quarkus_extensions = "all-quarkus-extensions";
        public static String config_hover = "config-hover";
        public static String config_properties = "config-properties";
        public static String config_quickstart = "config-quickstart";
        public static String config_quickstart_test = "config-quickstart-test";
        public static String empty_maven_project = "empty-maven-project";
        public static String other_empty_maven_project = "empty-maven-project";
        public static String folder_name_different_maven = "folder-name-different-maven";
        public static String hibernate_orm_resteasy = "hibernate-orm-resteasy";
        public static String hibernate_orm_resteasy_yaml = "hibernate-orm-resteasy-yaml";
        public static String microprofile_applicationpath = "microprofile-applicationpath";
        public static String microprofile_configproperties = "microprofile-configproperties";
        public static String microprofile_fault_tolerance = "microprofile-fault-tolerance";
        public static String microprofile_health_quickstart = "microprofile-health-quickstart";
        public static String microprofile_health_3 = "microprofile-health-3";
        public static String microprofile_lra = "microprofile-lra";
        public static String microprofile_context_propagation = "microprofile-context-propagation";
        public static String microprofile_metrics = "microprofile-metrics";
        public static String microprofile_opentracing = "microprofile-opentracing";
        public static String microprofile_openapi = "microprofile-openapi";
        public static String microprofile_reactive_messaging = "microprofile-reactive-messaging";
        public static String microprofile_graphql = "microprofile-graphql";
        public static String microprofile_jwt_quickstart = "microprofile-jwt-quickstart";
        public static String rest_client_ee9 = "rest-client-ee9";
        public static String rest_client_quickstart = "rest-client-quickstart";
        public static String using_vertx = "using-vertx";
        public static String open_liberty = "open-liberty";
    }
}

