/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core.faulttolerance;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCompletionParams;
import org.eclipse.lsp4mp.jdt.core.BasePropertiesManagerTest;
import org.eclipse.lsp4mp.jdt.core.MicroProfileForJavaAssert;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.junit.Test;

public class MicroProfileFaultToleranceJavaCompletionTest
extends BasePropertiesManagerTest {
    @Test
    public void fallbackMethodCompletion() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/FaultTolerantResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(21, 33)), utils, MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "hello"), "hello()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "hi"), "hi()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "bbb"), "bbb()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "stringMethod"), "stringMethod()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "ccc"), "ccc()", CompletionItemKind.Method));
    }

    @Test
    public void fallbackMethodCompletionBeginning() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/FaultTolerantResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(21, 32)), utils, MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "hello"), "hello()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "hi"), "hi()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "bbb"), "bbb()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "stringMethod"), "stringMethod()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(21, 32, 21, 35, "ccc"), "ccc()", CompletionItemKind.Method));
    }

    @Test
    public void fallbackMethodNoCompletionOutside() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/FaultTolerantResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(21, 31)), utils, new CompletionItem[0]);
    }

    @Test
    public void fallbackMethodEmptyQuotes() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/OtherFaultToleranceResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(28, 32)), utils, MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "hello"), "hello()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "hi"), "hi()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "third"), "third()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "fourth"), "fourth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "fifth"), "fifth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(28, 32, 28, 32, "aaa"), "aaa()", CompletionItemKind.Method));
    }

    @Test
    public void fallbackMethodNoSpacesAroundEquals() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/OtherFaultToleranceResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(35, 30)), utils, MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "hello"), "hello()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "hi"), "hi()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "third"), "third()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "fourth"), "fourth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "fifth"), "fifth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(35, 30, 35, 30, "aaa"), "aaa()", CompletionItemKind.Method));
    }

    @Test
    public void fallbackMethodMultiline() throws Exception {
        IJavaProject javaProject = MicroProfileFaultToleranceJavaCompletionTest.loadMavenProject(BasePropertiesManagerTest.MicroProfileMavenProjectName.microprofile_fault_tolerance);
        IJDTUtils utils = JDT_UTILS;
        IFile javaFile = javaProject.getProject().getFile((IPath)new Path("src/main/java/org/acme/OtherFaultToleranceResource.java"));
        String javaFileUri = MicroProfileForJavaAssert.fixURI(javaFile.getLocation().toFile().toURI());
        MicroProfileForJavaAssert.assertJavaCompletion(new MicroProfileJavaCompletionParams(javaFileUri, MicroProfileForJavaAssert.p(43, 9)), utils, MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "hello"), "hello()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "hi"), "hi()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "third"), "third()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "fourth"), "fourth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "fifth"), "fifth()", CompletionItemKind.Method), MicroProfileForJavaAssert.c(MicroProfileForJavaAssert.te(43, 9, 43, 9, "aaa"), "aaa()", CompletionItemKind.Method));
    }
}

