/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4mp.commons.DocumentFormat;
import org.eclipse.lsp4mp.commons.JavaFileInfo;
import org.eclipse.lsp4mp.commons.MicroProfileDefinition;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeActionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaCodeLensParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDefinitionParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaDiagnosticsParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaFileInfoParams;
import org.eclipse.lsp4mp.commons.MicroProfileJavaHoverParams;
import org.eclipse.lsp4mp.jdt.core.java.codelens.JavaCodeLensContext;
import org.eclipse.lsp4mp.jdt.core.java.definition.JavaDefinitionContext;
import org.eclipse.lsp4mp.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4mp.jdt.core.java.hover.JavaHoverContext;
import org.eclipse.lsp4mp.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4mp.jdt.internal.core.java.JavaFeaturesRegistry;
import org.eclipse.lsp4mp.jdt.internal.core.java.codeaction.CodeActionHandler;
import org.eclipse.lsp4mp.jdt.internal.core.java.codelens.JavaCodeLensDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.definition.JavaDefinitionDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.diagnostics.JavaDiagnosticsDefinition;
import org.eclipse.lsp4mp.jdt.internal.core.java.hover.JavaHoverDefinition;

public class PropertiesManagerForJava {
    private static final PropertiesManagerForJava INSTANCE = new PropertiesManagerForJava();
    private final CodeActionHandler codeActionHandler = new CodeActionHandler();

    public static PropertiesManagerForJava getInstance() {
        return INSTANCE;
    }

    private PropertiesManagerForJava() {
    }

    public JavaFileInfo fileInfo(MicroProfileJavaFileInfoParams params, IJDTUtils utils, IProgressMonitor monitor) {
        String uri = params.getUri();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        if (unit != null && unit.exists()) {
            JavaFileInfo fileInfo = new JavaFileInfo();
            String packageName = unit.getParent() != null ? unit.getParent().getElementName() : "";
            fileInfo.setPackageName(packageName);
            return fileInfo;
        }
        return null;
    }

    public List<? extends CodeAction> codeAction(MicroProfileJavaCodeActionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        return this.codeActionHandler.codeAction(params, utils, monitor);
    }

    public List<? extends CodeLens> codeLens(MicroProfileJavaCodeLensParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return Collections.emptyList();
        }
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        this.collectCodeLens(uri, typeRoot, utils, params, lenses, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return lenses;
    }

    private void collectCodeLens(String uri, ITypeRoot typeRoot, IJDTUtils utils, MicroProfileJavaCodeLensParams params, List<CodeLens> lenses, IProgressMonitor monitor) {
        JavaCodeLensContext context = new JavaCodeLensContext(uri, typeRoot, utils, params);
        List<JavaCodeLensDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaCodeLensDefinitions().stream().filter(definition -> definition.isAdaptedForCodeLens(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginCodeLens(context, monitor));
        definitions.forEach(definition -> {
            List<CodeLens> collectedLenses = definition.collectCodeLens(context, monitor);
            if (collectedLenses != null && !collectedLenses.isEmpty()) {
                lenses.addAll(collectedLenses);
            }
        });
        definitions.forEach(definition -> definition.endCodeLens(context, monitor));
    }

    public List<MicroProfileDefinition> definition(MicroProfileJavaDefinitionParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return Collections.emptyList();
        }
        Position hyperlinkedPosition = params.getPosition();
        int definitionOffset = utils.toOffset(typeRoot.getBuffer(), hyperlinkedPosition.getLine(), hyperlinkedPosition.getCharacter());
        IJavaElement hyperlinkedElement = this.getHoveredElement(typeRoot, definitionOffset);
        ArrayList<MicroProfileDefinition> locations = new ArrayList<MicroProfileDefinition>();
        this.collectDefinition(uri, typeRoot, hyperlinkedElement, utils, hyperlinkedPosition, locations, monitor);
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return locations;
    }

    private void collectDefinition(String uri, ITypeRoot typeRoot, IJavaElement hyperlinkedElement, IJDTUtils utils, Position hyperlinkedPosition, List<MicroProfileDefinition> locations, IProgressMonitor monitor) {
        JavaDefinitionContext context = new JavaDefinitionContext(uri, typeRoot, utils, hyperlinkedElement, hyperlinkedPosition);
        List<JavaDefinitionDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaDefinitionDefinitions().stream().filter(definition -> definition.isAdaptedForDefinition(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginDefinition(context, monitor));
        definitions.forEach(definition -> {
            List<MicroProfileDefinition> collectedDefinitions = definition.collectDefinitions(context, monitor);
            if (collectedDefinitions != null && !collectedDefinitions.isEmpty()) {
                locations.addAll(collectedDefinitions);
            }
        });
        definitions.forEach(definition -> definition.endDefinition(context, monitor));
    }

    public List<PublishDiagnosticsParams> diagnostics(MicroProfileJavaDiagnosticsParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        List<String> uris = params.getUris();
        if (uris == null) {
            return Collections.emptyList();
        }
        DocumentFormat documentFormat = params.getDocumentFormat();
        ArrayList<PublishDiagnosticsParams> publishDiagnostics = new ArrayList<PublishDiagnosticsParams>();
        for (String uri : uris) {
            ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
            PublishDiagnosticsParams publishDiagnostic = new PublishDiagnosticsParams(uri, diagnostics);
            publishDiagnostics.add(publishDiagnostic);
            this.collectDiagnostics(uri, utils, documentFormat, diagnostics, monitor);
        }
        if (monitor.isCanceled()) {
            return Collections.emptyList();
        }
        return publishDiagnostics;
    }

    private void collectDiagnostics(String uri, IJDTUtils utils, DocumentFormat documentFormat, List<Diagnostic> diagnostics, IProgressMonitor monitor) {
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return;
        }
        JavaDiagnosticsContext context = new JavaDiagnosticsContext(uri, typeRoot, utils, documentFormat);
        List<JavaDiagnosticsDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaDiagnosticsDefinitions().stream().filter(definition -> definition.isAdaptedForDiagnostics(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginDiagnostics(context, monitor));
        definitions.forEach(definition -> {
            List<Diagnostic> collectedDiagnostics = definition.collectDiagnostics(context, monitor);
            if (collectedDiagnostics != null && !collectedDiagnostics.isEmpty()) {
                diagnostics.addAll(collectedDiagnostics);
            }
        });
        definitions.forEach(definition -> definition.endDiagnostics(context, monitor));
    }

    public Hover hover(MicroProfileJavaHoverParams params, IJDTUtils utils, IProgressMonitor monitor) throws JavaModelException {
        String uri = params.getUri();
        ITypeRoot typeRoot = PropertiesManagerForJava.resolveTypeRoot(uri, utils, monitor);
        if (typeRoot == null) {
            return null;
        }
        Position hoverPosition = params.getPosition();
        int hoveredOffset = utils.toOffset(typeRoot.getBuffer(), hoverPosition.getLine(), hoverPosition.getCharacter());
        IJavaElement hoverElement = this.getHoveredElement(typeRoot, hoveredOffset);
        DocumentFormat documentFormat = params.getDocumentFormat();
        boolean surroundEqualsWithSpaces = params.isSurroundEqualsWithSpaces();
        ArrayList<Hover> hovers = new ArrayList<Hover>();
        this.collectHover(uri, typeRoot, hoverElement, utils, hoverPosition, documentFormat, surroundEqualsWithSpaces, hovers, monitor);
        if (hovers.isEmpty()) {
            return null;
        }
        if (monitor.isCanceled()) {
            return null;
        }
        return (Hover)hovers.get(0);
    }

    private IJavaElement getHoveredElement(ITypeRoot typeRoot, int offset) throws JavaModelException {
        IJavaElement hoverElement = typeRoot.getElementAt(offset);
        if (hoverElement == null) {
            return null;
        }
        if (hoverElement.getElementType() == 9) {
            hoverElement = this.getHoveredMethodParameter((IMethod)hoverElement, offset);
        }
        return hoverElement;
    }

    private IJavaElement getHoveredMethodParameter(IMethod method, int offset) throws JavaModelException {
        ILocalVariable[] parameters = method.getParameters();
        int i = 0;
        while (i < parameters.length) {
            ISourceRange range = parameters[i].getSourceRange();
            int start = range.getOffset();
            int end = start + range.getLength();
            if (start <= offset && offset <= end) {
                return parameters[i];
            }
            ++i;
        }
        return method;
    }

    private void collectHover(String uri, ITypeRoot typeRoot, IJavaElement hoverElement, IJDTUtils utils, Position hoverPosition, DocumentFormat documentFormat, boolean surroundEqualsWithSpaces, List<Hover> hovers, IProgressMonitor monitor) {
        JavaHoverContext context = new JavaHoverContext(uri, typeRoot, utils, hoverElement, hoverPosition, documentFormat, surroundEqualsWithSpaces);
        List<JavaHoverDefinition> definitions = JavaFeaturesRegistry.getInstance().getJavaHoverDefinitions().stream().filter(definition -> definition.isAdaptedForHover(context, monitor)).collect(Collectors.toList());
        if (definitions.isEmpty()) {
            return;
        }
        definitions.forEach(definition -> definition.beginHover(context, monitor));
        definitions.forEach(definition -> {
            Hover hover = definition.collectHover(context, monitor);
            if (hover != null) {
                hovers.add(hover);
            }
        });
        definitions.forEach(definition -> definition.endHover(context, monitor));
    }

    private static ITypeRoot resolveTypeRoot(String uri, IJDTUtils utils, IProgressMonitor monitor) {
        utils.waitForLifecycleJobs(monitor);
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        IClassFile classFile = null;
        if (unit == null ? (classFile = utils.resolveClassFile(uri)) == null : !unit.getResource().exists() || monitor.isCanceled()) {
            return null;
        }
        return unit != null ? unit : classFile;
    }
}

